from OFS.Image import cookId

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Objects.Ratings.Ratings import Rating
from Products.Gideon.Log.Log import LogFactory
from Products.Gideon.PageContract.Scripts import compile
from Products.Gideon.Objects.Catalog import CatalogSchema
from Products.Gideon.Objects.Authors.Authors import Author, make_author_id

from PackageFile import PackageFile
from PackageVersion import PackageVersionContainer, PackageVersion
from PackageDependency import PackageDependency
from PackageHistory import PackageHistory
from PackageStateVariables import PackageStateVariables


log = LogFactory('Package Admin')

class PackageAdmin(SimpleItem, Implicit):
    
    """
    Adminstrative Views and logic for manipulation
    of state.
    """

    security = ClassSecurityInfo()

    security.declareObjectProtected('View Package Admin')
    

    ### ui
    security.declareProtected('View Package Admin', 'index_html')
    index_html = DTMLFile('ui/PackageAdminView', globals())

    security.declareProtected('View Package Admin', 'edit_package_info_form')
    edit_package_info_form = DTMLFile('ui/PackageAdminEditInfoForm',globals())

    security.declareProtected('View Package Admin',
                              'edit_package_versions_form')
    edit_package_versions_form = DTMLFile('ui/PackageAdminEditVersionsForm',
                                          globals())
    
    security.declareProtected('View Package Admin',
                              'edit_packag_dependencies_form')
    edit_package_dependencies_form = \
                   DTMLFile('ui/PackageAdminEditDependenciesForm', globals())

    security.declareProtected('Publish Package',
                              'edit_package_approve_form')
    edit_package_approve_form = \
                   DTMLFile('ui/PackageAdminApproveForm', globals())

    security.declareProtected('View Package Admin',
                              'edit_package_categories_form')
    edit_package_categories_form = \
                   DTMLFile('ui/PackageAdminEditCategories', globals())

    security.declareProtected('View Package Admin',
                              'edit_package_authors_form')
    edit_package_authors_form = \
                   DTMLFile('ui/PackageAdminEditAuthors', globals())

    security.declareProtected('View Package Admin','view_package_history')
    view_package_history = \
                   DTMLFile('ui/PackageHistoryView', globals())    
    

    ## state based widgets
    _widget_for_queue = DTMLFile('ui/PackageAdminQueueWidget',globals())
    
    _widget_for_published = \
                   DTMLFile('ui/PackageAdminPublishedWidget',globals())
    
    _menu_for_published = DTMLFile('ui/PackageAdminPublishedMenu',globals())
    
    def __init__(self,
                 id = 'Admin'
            ):
        self.id = id
        self._state = ''

    security.declarePublic('get_admin_widget')
    def get_admin_widget(self):
        """this gets called from the package view """
        package = self.get_package()
        if package._published:
            return self._widget_for_published(self, self.REQUEST)
        else:
            return self._widget_for_queue(self, self.REQUEST)
        
    security.declarePublic('get_admin_widget')
    def get_admin_menu(self):
        """ this gets called from the admin view """
        package = self.get_package()        
        if package._published:
            return self._menu_for_published(self, self.REQUEST)
        else:
            return self._widget_for_queue(self, self.REQUEST)            

    # submit methods
    security.declareProtected('Publish Package',
                              'edit_package_approve')
    def edit_package_approve(self, REQUEST):
        """ """
        contract = """
        #parameters
        package_notes:optional, trim, nohtml
        """
        contract = compile(contract)
        contract.validate(self)
        
        #if REQUEST.has_key('package_notes'):
        #    package_notes = REQUEST['package_notes']
         
        pid = self.get_package_info().package_name()
        log.debug('approving package (%s) in queue'%pid)

        queue = self.get_inner_application(self)
        package = self.get_package()

        log.debug('removing package (%s) in queue'%pid)		
        queue.remove_package(package)
        
        log.debug('adding package (%s) to published packages'%pid)		
        package_container = self.get_inner_application(self, 2) 
        package_container.add_package(self.aq_parent.aq_base)
        
        # record for posterity
        history = package.get_history()
        # this is none if anonymous
        log.debug('adding note user currently %s'%(
             getSecurityManager().getUser().getId()
             )
            )
        history.add_note('transition',
                         'package published %s'%REQUEST['package_notes'])

        # redirect back to queue
        if REQUEST is not None:
            REQUEST.RESPONSE.redirect(queue.absolute_url()+\
                                      '?message='+pid+'+published')
        
    security.declareProtected('Add Distribution Files',
                              'package_add_version_file')
    def package_add_version_file(self, REQUEST):
        """ """
        contract = """
        #parameters
        version_file:file
        file_type:trim, constraint(supported_file_types)
        platform:trim, constraint(supported_platforms)
        """
        #version_id:trim, obid(Versions)
        
        contract = compile(contract,self)
        
        # hmm.. err handling seems to trigger a bug... todo list for the moment
        # hopefully that fixes it
        contract.validate(self)
        
        container = self.get_version_container()
        version = container._getOb(REQUEST['version_id'])
        
        id, title = cookId('','',REQUEST['version_file'])
        
        fobj= PackageFile(id, 
                          title, 
                          REQUEST['file_type'],
                          'tgz',
                          REQUEST['platform'])
        
        version.add_file(fobj)
        
        fobj = version._getOb(id)
        fobj.manage_upload(REQUEST['version_file'])
        
        history = self.get_package().get_history()
        history.add_note("addition", "file added")
        
        REQUEST.RESPONSE.redirect('.')

    def package_create_version(self, REQUEST):
        """ create a new package version """
        contract = """
        #parameters
        version_id:trim
        """ 
        contract = compile(contract)
        contract.validate(self)
        
        version = PackageVersion(REQUEST['version_id'])
        version_container = self.get_version_container()        
        
        version_container.add_version(version)

        history = self.get_package().get_history()
        history.add_note("addition", "version added")        

        # hmm.. where to redirect        
        REQUEST.RESPONSE.redirect('.')
                                       

    def edit_package_versions(self, REQUEST):
        """ """
        
    def package_add_dependency(self, REQUEST=None, **kw):
        """ """
        contract = """
        #parameters
        package_version:trim, validid
        dependency_name:trim, validid
        type:trim, constraint(supported_dependency_types)
        kind:trim, constraint(supported_dependency_kinds)
        architecture:trim, constraint(supported_architectures)
        min_version:trim
        max_version:optional, trim
        """

        # we will manually process package_version

        if REQUEST is not None:
            contract = compile(contract, self)
            contract.validate(REQUEST)
            vars = contract.extract_variables(REQUEST)
        elif kw:
            vars = kw
        else:
            raise "No Args Supplied to package add dependency"

        package = self.get_package()
        versions = package.get_version_container()

        dependency = PackageDependency(
                     vars.dependency_name,
                     vars.type,
                     vars.kind,
                     vars.architecture,
                     vars.min_version,
                     vars.max_version
            )

        if vars.package_version == 'All':
            versions.add_global_dependency(dependency)
        else:
            version = versions.get_version(vars.package_version)
            version.add_version_dependency(dependency)
            
        history = package.get_history()
        
        history.add_note("addition", "%s dependency added"%(
            vars.dependency_name)
                         )
        
        if REQUEST:
            REQUEST.RESPONSE.redirect(
                'edit_package_dependencies_form?message=dependency+added')

    def package_remove_dependency(self,
                                  dependency_name,
                                  version_id='', 
                                  REQUEST=None
                                  ):
        """ """ 
        package = self.get_package()

        versions = package.get_version_container()

        if version_id:
            version = versions.get_version(version_id)
            version.remove_dependency(dependency_name)
        else:
            versions.remove_global_dependency(dependency_name)

        history = package.get_history()
        history.add_note("removal", "%s dependency removed"%dependency_name)

        if REQUEST:
            REQUEST.RESPONSE.redirect(
                'edit_package_dependencies_form?message=dependency+removed')

        
    def package_add_authors(self,
                            first_name,
                            last_name,
                            public_email,
                            homepage='',
                            REQUEST=None):
        """ 
        authors for new packages are first stored as state vars
        till the package gets published, then they get added to the 
        author container via the event channel. there after they
        get added directly to the author_container.
        """
        contract = """
        first_name:trim
        last_name:trim
        public_email:trim, email
        homepage:trim
        """
        contract = compile(contract)
        contract.validate(REQUEST)

        aid = make_author_id(first_name, last_name)
        
        if self.get_package().is_published() == 1:
            author_container = self.get_application_for_name('Authors')
            if author_container.get_author(aid, None) is None:
                author_container.add_author(first_name, last_name, public_email, homepage)
        else:
            statevars = self.get_state_vars()
            authors = statevars.get('authors', [])
            authors.append(Author(aid, first_name, last_name, public_email))
            statevars['authors']=authors
            
        REQUEST.RESPONSE.redirect('.')
        
        
        
    def edit_package_info(self, REQUEST):
        """ """
        contract = """
        #parameters
        summary:trim
        license:trim, constraint(supported_licenses)
        description:trim
        platform:constraint(supported_platforms)
        """
        contract = compile(contract, self)
        contract.validate(self)

        vars = contract.extract_variables(REQUEST)
        info = self.get_package_info()
        
        for k,v in vars.items():
            method = getattr(info, 'set_'+k, None)
            if method: method(v)
        
        history = self.get_package().get_history()
        history.add_note("edit", "package info edited")        
        REQUEST.RESPONSE.redirect('.')

    
    def edit_package_categories(self, REQUEST):
        """ """
        # need a constrainted list contract
        contract = """
        #parameters
        package_categories:trim
        """
        categories = REQUEST['package_categories']
        info = self.get_package_info()
        
        info.set_categories(categories)
        
        # event broadcast to listeners
        if self.get_package_info().is_published():        
            channel = self.get_service("EventChannel")
            channel.publish(self.get_package(), "package categories modified")
        
        history = self.get_package().get_history()
        history.add_note("edit", "package categories edited")
        REQUEST.RESPONSE.redirect('.')
 


InitializeClass(PackageAdmin)
