from AccessControl import ClassSecurityInfo
from Globals import DTMLFile, InitializeClass
from Acquisition import aq_base, Implicit
from OFS.SimpleItem import SimpleItem
from OFS.Folder import Folder
from Interface import Base
from ComputedAttribute import ComputedAttribute

from Products.Gideon.Objects.Application.PythonRepository \
     import RepositoryApplication

from Products.Gideon.Objects.Catalog import CatalogSchema

from Products.Gideon.PageContract.Scripts import compile
from Products.Gideon.Log.Log import LogFactory
from Products.Gideon import FileSystem
from Products.Gideon import MetaDataParsers

from PackageSchema import package_schema

log = LogFactory('Package Application')

class PackageAppEventProxy(SimpleItem, Implicit): 
    
    def __init__(self, id):
        self.id = id
        
    def categories_changed(self, package, *args):
        catalog = self.get_service("PackageCatalog")
        catalog.catalog_object(package.get_package_info())
    
    def event_package_published(self, package, *args):
        catalog = self.get_service("PackageCatalog")
        catalog.catalog_object(package.get_package_info())

    def manage_afterAdd(self, item, container):
        ec = self.get_service("EventChannel")
        ec.register_listener(self, 'categories_changed', 'package categories modified')

        
class PackageApplication(RepositoryApplication,Folder):
    """
    this is a doc string.
    """
    
    meta_type = 'Package Container'
    
    security = ClassSecurityInfo()
    
    security.declarePublic('index_html')
    index_html = DTMLFile('ui/PackageContainerView', globals())
    
    security.declarePublic('search_results')
    search_results = DTMLFile('ui/PackageContainerSearchResults',globals())

    security.declarePublic('advanced_search')
    advanced_search = DTMLFile('ui/PackageContainerAdvancedSearchForm',
                               globals())
    
    security.declarePublic('recent_packages')
    recent_packages = DTMLFile('ui/PackageContainerRecentPackages', globals())

    ## variable configuration below
    def _get_available_categories(self):
        return [c.getId() for c in self.Categories.get_all_categories()]
    
    available_categories = ComputedAttribute(_get_available_categories)
    
    supported_python_versions = ('2.2.1',
                                 '2.2.0',
                                 '2.1.2',
                                 '2.1.1',
                                 '2.1.0',
                                 '2.0.2',
                                 '2.0.1',
                                 '2.0.0',
                                 '1.6.1',
                                 '1.6.0',
                                 '1.5.2')
    
    major_python_versions = ('2.2',
                             '2.1',
                             '2.0',
                             '1.6',
                             '1.5')
    
    supported_dependency_kinds = ('REQUIRES',
                                  'SUGGESTS',
                                  'RECOMMENDS',
                                  'CONFLICTS',
                                  'REPLACES')
    
    supported_platforms = ('all','win32', 'solaris', 'linux', 'mac x')
    supported_file_types = ('source', 'binary', 'documentation')
    supported_licenses = ('BSD', 'LGPL', 'GPL', 'ZPL', 'MIT', 'MPL', 'Other')
    supported_dependency_types = ('python', 'external')
    
    supported_architectures = ('i386', 'alpha', 'mips', 'powerpc')
    supported_file_formats = ComputedAttribute(FileSystem.get_file_formats)
    
    supported_metadata_formats = \
                        ComputedAttribute(MetaDataParsers.supported_formats)

    security.declarePrivate('add_package')
    def add_package(self, package):
        log.debug('adding package')
        
        # play name games
        pid = package.get_package_info().package_name()
        char = pid.lower()[0]

        # store it
        package_folder = self._getOb(char, None)
        if package_folder is None:
            package_folder = self._getOb('misc')
        package_folder._setObject(pid, aq_base(package))
        
        # get a newly wrapped reference
        package = package_folder._getOb(pid)

        # tell the package its approved
        package.set_published(1)
        
        # index it
        cat = self.get_service("PackageCatalog")
        cat.catalog_object(package.get_package_info())
        
        # tell others about it
        ec = self.get_service("EventChannel")
        ec.publish(package, 'package published')
        
    security.declarePublic("search_packages")
    def search_packages(self, REQUEST):
        contract = """
        #parameters
        SearchableText:optional,trim,nohtml
        package_licenses:optional,trim,nohtml
        """        
        contract = compile(contract)
        contract.validate(self)

        log.debug('searching packages')
        query = CatalogSchema.extract_query(REQUEST, package_schema)
        print 'query', query
        
        query['meta_type']='Package Info'        
        if REQUEST.has_key('SearchableText'):
            query['SearchableText'] = REQUEST['SearchableText']
        else:
            print REQUEST.form.keys(), REQUEST.has_key('SearchableText')
            return ()
        catalog = self.get_service("PackageCatalog")
        res = catalog(**query)
        
        return res

    security.declarePublic('get_package_queue')
    def get_package_queue(self):
        return self.PackageQueue
    
    security.declarePublic('get_package_licenses')
    def get_package_licenses(self):
        """ return the existing licenses """
        catalog = self.get_service("PackageCatalog")
        return catalog.uniqueValuesFor('package_license')
    
    security.declarePrivate('get_package_filesystem')
    def get_package_filesystem(self):
        return get_file_system()
    
    security.declarePublic('get_packages_for_author')
    def get_packages_for_author(self, author):
        catalog = self.get_service("PackageCatalog")
        query = {}
        query['package_authors']=author
        query['meta_type']='Package Info'
        res = catalog(**query)
        return res
    
    security.declarePublic('get_related_packages')
    def get_related_packages(self, package):
        """ Hmm.. how to define relationships, categories? """
        categories = package.get_package_info().package_categories()
        catalog = self.get_service('PackageCatalog')
        return cat.query(package_categories=categories)

    def manage_afterAdd(self, item, container):
        """ """
        CatalogSchema.install_catalog_schema('PackageCatalog',
                                             package_schema,
                                             self)
        self._setObject('event_proxy', PackageAppEventProxy('event_proxy'))

    def upgrade(self):
        """ """
        return 0
    
InitializeClass(PackageApplication)	
