from Products.Gideon.Objects.Namespace import *

class PackageDependency(SimpleItem):
    
    meta_type = 'Package Dependency'

    __call__ = DTMLFile('ui/PackageDependencyWidget',globals())
    
    def __init__(self,
                 id,
                 type,
                 kind,
                 platform='all',
                 min_version='',
                 max_version=''
                 ):
        
        self.id = id
        self.type = type
        self.name = name
        self.platform = platform
        self.min_version = min_version
        self.max_version = max_version
        self.created = DateTime()
        
    def get_dependency(self):
        app = self.get_application_for_name('Packages')
        return app.get_package(self.name, '')

