import os
from os import path
import zipfile

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.FileSystem.BucketDirectory import make_letter_buckets
from Products.Gideon import gideon_home

from Globals import HTMLFile

default_export = os.path.join(gideon_home, 'var','export')

export_package_info = HTMLFile('export/PackageInfo', globals())
export_package_history = HTMLFile('export/PackageHistory', globals())
export_versions_info = HTMLFile('export/VersionsInfo', globals())
export_version_depends = HTMLFile('export/GlobalDepends', globals())
export_global_depends = HTMLFile('export/GlobalDepends', globals())


class PackageExport(SimpleItem):
    
    """
    allows packages and repository  state to be dumped
    to the fs in zipped xml metadata files and distro files,
    this format is completely ad hoc. mainly done so the
    repository have its state dumped during refactoring/upgrades
    """

    def __init__(
        self,
        id,
        export_directory=default_export
        ):
        
        self.id = id
        self._directory = export_directory

    def get_packages(self):
        
        app = self.get_inner_application(self)
        folders = app.objectValues('Package Folder')            

        res = []
        for f in folders:
            res.extend(f.objectValues('Package'))
            
        return res

    def marshal_package(self, package):
        
        # turn a package into a zip file

        # need to do some sort of letter check ie. 4suite
        archive_name = os.sep.join([package.getId().lower()[0],
                                    package.getId()+'.zip'])

        archive_prefix = package.getId()
        
        archive = zipfile.ZipFile(archive_name,
                                  mode='w')

        # package info
        package_info = package.get_package_info()
        zinfo = zipfile.ZipInfo(path.join(archive_prefix,'package_info.xml'))
        archive.writestr(zinfo, export_package_info(None, package_info))

        # package history
        package_history = package.get_history()
        zinfo = zipfile.ZipInfo(path.join(archive_prefix,
                                          'package_history.xml'))
        archive.writestr(zinfo, export_package_history(None,package_history))
        
        versions = package.Versions
        
        # global dependencies
        zinfo = zipfile.ZipInfo(
            path.join(archive_prefix, 'versions', 'global-depends.xml')
            )
        
        archive.writestr(zinfo,
            export_global_depends(None, versions,
                         dependencies=versions.get_global_dependencies())
                         )
        
        # versions
        for v in versions.get_versions():
            version_path = path.join('versions', v.getId())

            zinfo = zipfile.ZipInfo(
                path.join(archive_prefix, version_path,'version-depends.xml')
                )

            archive.writestr(zinfo,
                   export_version_depends(None, v,
                         dependencies = v.get_dependencies()
                                          )
                             )

            for f in v.get_files():
                zinfo = zipfile.ZipInfo(path.join(
                            archive_prefix, version_path,f.getId()
                            )
                        )
                archive.writestr(zinfo, str(f))

        # dangling stuff
        zinfo = zipfile.ZipInfo(path.join(archive_prefix, 'versions.xml'))
        archive.writestr(zinfo, export_versions_info(None,versions))
        
        archive.close()
        
    def export_packages(self):
        """ """
        curdir = os.getcwd()

        # export the published packages
        
        setup_export_space(self._directory)
        
        packages = []
        try:
            packages = self.get_packages()
            map(self.marshal_package, self.get_packages())
        finally:
            os.chdir(curdir)

        # punt on queue packages for now
        
        os.chdir(curdir)
        
        return packages

        
def setup_export_space(directory):
    
    os.chdir(directory)
    directories = os.listdir(os.getcwd())

    if not directories:
        make_letter_buckets(os.getcwd())
        
