from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log.Log import log
from Products.Gideon.PageContract.Scripts import compile
from Products.Gideon.Objects.Catalog import CatalogSchema

from PackageSchema import package_schema

class PackageFolder(Folder):		

    meta_type = 'Package Folder'

    security = ClassSecurityInfo()

    security.declarePublic('index_html')
    index_html = DTMLFile('ui/PackageFolderView', globals())

    security.declarePublic('index_html')
    search_results = DTMLFile('ui/PackageFolderResults',globals())

    # only because dtmlfile is unrestricted code
    security.declarePrivate('search_results')
    def search_packages(self, REQUEST):
        """ """
        contract = """
        #parameters
        SearchableText:optional,trim,nohtml
        package_licenses:optional,trim,nohtml
        """        
        contract = compile(contract, self)
        contract.validate(self)

        if not REQUEST.has_key('SearchableText'): return ()
        
        query = CatalogSchema.extract_query(REQUEST, package_schema)
        
        query['package_description'] = REQUEST['SearchableText']
        query['meta_type']='Package Info'
        query['path']='/'.join(self.getPhysicalPath())

        app = self.get_inner_application(self)
        catalog = app.get_service("PackageCatalog")        

        return catalog(**query)

InitializeClass(PackageFolder)
    
