from Products.Gideon.Objects.Namespace import *
from BTrees.OIBTree import OISet
from DateTime.DateTime import DateTime

class PackageHistoryNote(SimpleItem):

    index_html = None
    
    __call__ = DTMLFile('ui/PackageHistoryNoteView', globals())
    
    def __init__(
                 self, 
                 userid,
                 type,
                 state,
                 date,
                 description
                 ):
                 
        self._userid = userid
        self._type   = type
        self._state  = state
        self._date   = date
        self._description = description
        
    ## to prevent modifications from restricted code we
    ## stick in accessors
    def userid(self): return self._userid
    def type(self): return self._type
    def state(self): return self._state
    def description(self): return self._description
    def date(self): return self._date
        
class IPackageHistory(Base):
    
    def add_note(self, type, description):
        """ """

class PackageHistory(SimpleItem):
    """
    This object holds a log of state changes.
    
    its main purpose is for accountability.
    """
    
    meta_type = 'Package History'

    security = ClassSecurityInfo()
    
    __implements__ = (IPackageHistory,)
    
    index_html = DTMLFile('ui/PackageHistoryView', globals())
    
    def __init__(self, id):
        self.id  = id
        self._book = OISet()

    security.declarePrivate('add_note')
    def add_note(self, type, description):

        stateid = self.aq_inner.aq_parent.get_state_id()
        userid  = getSecurityManager().getUser().getId()
        date    = DateTime()
        
        note = PackageHistoryNote(userid, type, stateid, date, description)
        
        self._book.insert(note)
    
    security.declarePublic('get_all_notes')
    def get_all_notes(self): 
        return map(None, self._book)
        
    security.declarePrivate('get_notes_for_state')
    def get_notes_for_state(self, state):
        
        stateid = state.getId()
        
        return [n for n in self._book if n.state == stateid]