from OFS.SimpleItem import SimpleItem
from Acquisition import Implicit, aq_inner, aq_parent
from AccessControl import ClassSecurityInfo
from ZODB.PersistentMapping import PersistentMapping
from DateTime.DateTime import DateTime

from Products.Gideon.Objects.Namespace import *

class PackageInfo(SimpleItem, Implicit):
		
	meta_type = 'Package Info'
	
	security = ClassSecurityInfo()
	
	index_html = None

	__call__ = DTMLFile('ui/PackageInfoView', globals())
	
	def __init__(
			self,
			id = 'info',
			info={}
			): 
		self.id = id
		self.info = PersistentMapping()
		self.info.update(info)
		self.info['upload_date'] = DateTime()

	def get_info(self): return self.info
	
	## info discovery interface -- (cataloged)
	def package_name(self):
		return self.info['name']
	
	def package_url(self):
		return '/'.join(aq_parent(aq_inner(self)).getPhysicalPath())

	def package_summary(self):
		return self.info['summary']
	
	def package_description(self):
		return self.info['description']
	
	def package_license(self):
		return self.info['license']

	def package_authors(self):
		return self.info['author']
	
	def package_company(self):
		return self.info.get('company', None)

	def package_categories(self):
		return self.info.get('categories', ())
	
	def package_keywords(self):
		return self.info.get('keywords', None)
	
	def package_upload_date(self):
		return self.info.get('upload_date')
	
	def SearchableText(self):
		""" """
		text = [self.package_name(),
		        self.package_summary(),
		        self.package_description(),
		        self.package_keywords()]
		
		return ' '.join(filter(None,text))
		        
	def assigned_user(self):
		return self.info.get('assigned_user', '')
	def set_assigned_user(self, userid):
		self.info['assigned_user']=userid
	
	## info set interface
	
	def set_name(self, name):
		self.info['name'] = name
	def set_summary(self, summary):
		self.info['summary']=summary
	def set_description(self, description):
		self.info['description']=description
	def set_authors(self, authors):
		self.info['author'] = authors
	def set_company(self, company):
		self.info['company'] = company
	def set_keywords(self, keywords):
		self.info['keywords'] = keywords
	def set_license(self, license):
		self.info['license'] = license
	def set_categories(self, categories):
		self.info['categories']=categories
	def set_platforms(self, platforms):
		self.info['platforms']=platforms
	def set_homepage(self, homepage):
		self.info['home-page']=homepage
		
	## for enforcing some sort of schema
	def get_remaining_required(self): 
		pass
	