from AccessControl import ClassSecurityInfo, getSecurityManager
from OFS.Folder import Folder
from Globals import DTMLFile, InitializeClass


from Products.Gideon.Objects.Catalog import CatalogSchema
from Products.Gideon.Objects.Application.PythonRepository \
     import RepositoryApplication
from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log.Log import LogFactory
from PackageSchema import queue_schema

log = LogFactory('Package Queue')

class PackageQueue(RepositoryApplication):
	"""
	Package Queue
	"""

	meta_type = 'Package Queue'
	
	security = ClassSecurityInfo()
	security.declareObjectProtected('View Package Queue')

	security.declareProtected('View Package Queue', 'index_html')
	index_html = DTMLFile('ui/PackageQueueView', globals())

	security.declareProtected('View Package Queue', 'standard_html_header')
	standard_html_header = DTMLFile('ui/PackageQueueHeader', globals())
	
	security.declareProtected('View Package Queue', 'results_html')	
	results_html = DTMLFile('ui/PackageQueueSearchResults', globals())
	
	def __init__(self, id):
		self.id = id

	security.declarePrivate('add_package')
	def add_package(self, pkg_id, package):
		""" add a package and broadcast its inclusion
		to listeners """

		self._setObject(pkg_id, aq_base(package))
		package = self._getOb(pkg_id)

		catalog = self.get_service("QueueCatalog")
		catalog.catalog_object(package.get_package_info())
		
		channel = self.get_service("EventChannel")		
		channel.publish(package, 'package added to queue')

		package.get_history().add_note('transition',
					       'package added to queue')

	security.declarePrivate('add_package')
	def reindex_all(self):
		""" """
		catalog = self.QueueCatalog
		
		for o in self.objectValues('Package'):
			catalog.catalog_object(o.get_package_info())
			
	security.declarePrivate('remove_package')
	def remove_package(self, package):
		
		# package should have proper aq wrapper
		channel = self.get_service("EventChannel")		
		channel.publish(package, 'package removed from queue')

		cat = self.get_service('QueueCatalog')
		
		log.debug('unindexing %s'%'/'.join(
			package.get_package_info().getPhysicalPath()) )
		
		cat.uncatalog_object(
			'/'.join(
			    package.get_package_info().getPhysicalPath()
			    )
			)
		
		self._delObject(package.get_package_info().package_name())

	security.declarePrivate('get_user_assigned_packages')
	def get_user_assigned_packages(self):
		catalog = self.get_service("QueueCatalog")
		userid = getSecurityManager().getUser().getId()
		res = catalog(meta_type='Package Info', assigned_user=userid)
		return res
	
	security.declarePrivate('get_unassigned_packages')
	def get_unassigned_packages(self):
		cat = self.get_service("QueueCatalog")
		res = cat(meta_type='Package Info', assigned_user=('',))
		# this is prolly too expensive for large result sets
		# although the cat does some batching internally...
		return [cat.getobject(r.data_record_id_) for r in res]

	security.declareProtected('Manage Package Queue',
				  'assign_packages')
	
	def assign_package(self, pkgid, REQUEST):
		""" FIX allow user assignment """

		log.debug('assigning package')
		
		pkg = self._getOb(pkgid)
		userid = getSecurityManager().getUser().getId()
		info = pkg.get_package_info()
		info.set_assigned_user(userid)
		catalog = self.QueueCatalog
		catalog.catalog_object(info)
		
		REQUEST.RESPONSE.redirect('.')

	security.declareProtected('View Package Queue',
				  'search_queue_packages')
	def search_queue_packages(self, REQUEST):
		""" """
		
		catalog = self.get_service("QueueCatalog")
		
		res = catalog(meta_type='Package Info',
			      SearchableText=REQUEST.get('SearchableText')
			      )
		
		return self.results_html(self, REQUEST, results=res)

	security.declarePrivate('manage_afterAdd')
	def manage_afterAdd(self, item, container):
		
		CatalogSchema.install_catalog_schema('QueueCatalog',
						     queue_schema,
						     self)


	security.setPermissionDefault('View Package Queue',
				      ('Authenticated',)
				      )

	security.setPermissionDefault('Manage Package Queue',
				      ('Repository Admin',)
				      )

InitializeClass(PackageQueue)
