from Products.Gideon.Objects.Namespace import *
from ZODB.PersistentMapping import PersistentMapping

class IPackageStateVariables(Base):
    
    def get_variables_for_state(self, state):
        """ """
    def get_state_variables(self):
        """ """
    def set_state_variable(self, name, value):
        """ """
    
class PackageStateVariables(SimpleItem):
    """
    This object is held local to the package
    to store state specific data.
    
    This info persists across states
    """

    security = ClassSecurityInfo()
    
    security.declareObjectPrivate()
    
    def __init__(self, id):
        self.id = id
        self._data = PersistentMapping()
    
    def get_variables_for_state(self, state_id):
        vars =  self._data.get(state_id, None)
        if vars is None: 
            vars = PersistentMapping()
            self._data[state_id]=vars
        return vars
           
    def get_state_variables(self):
        package = self.aq_inner.aq_parent
        s = package.get_state_id()
        return self.get_variables_for_state(s)

    def get_state_variable(self, name):
        package = self.get_package()
        s = package.get_state_id()
        
    def set_state_variable(self, name, value):
        package = self.get_package()
        s = package.get_state_id()
        package.get_state_id()
        vars = self.get_variables_for_state(s, None)
        if vars is None:
            self._data[s]=PersistentMapping({name:value})
        else: vars[name]=value
            
        
        

        
InitializeClass(PackageStateVariables)        
        
        
