from ComputedAttribute import ComputedAttribute
from BTrees.IOBTree import IOSet
from OFS.Image import cookId

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.PageContract.Scripts import compile
from Products.Gideon import FileSystem
from Products.Gideon import MetaDataParsers
from Products.Gideon.Log.Log import log
		
from PackageInfo import PackageInfo
from PackageFile import PackageFile
from Package import Package
from PackageVersion import PackageVersion

## Page Contracts

metadata_creation_contract = """
#parameters
package_name:nohtml,trim
author_name:optional,trim
author_email:optional,trim
maintainer_email:optional,trim
package_url:optional,trim
company:optional,trim
category:optional,trim
"""
				
metadata_upload_contract = """
#parameters
metadata_file:file
metadata_format:constraint(supported_metadata_formats)
"""

version_upload_contract = """
#parameters
distribution_file:file
"""



class PackageUpload(Folder):

	meta_type = "Package Upload"
	
	index_html = DTMLFile('ui/PackageUploadView', globals())
	
	metadata_upload_form = DTMLFile('ui/PackageMetadataUploadForm',
					globals())

	metadata_required_form = DTMLFile('ui/PackagaMetadataRequiredForm',
					globals())
	
	metadata_edit_form = DTMLFile('ui/PackageMetadataEditForm',
	       			        globals())
	
	version_creation_form = DTMLFile('ui/PackageVersionCreationForm',
				        globals())
	
	version_edit_form = DTMLFile('ui/PackageVersionEditForm',
				        globals())
	
	version_upload_form = DTMLFile('ui/PackageVersionUploadForm',
				        globals())	
	
	def __init__(self,
			id,
			title):
		
		self.id = id
		self.title = title	 
	
	def _parse_metadata_file(self, fmt, file):
		return MetaDataParsers.parse(fmt, 'stream', file)
		
	def version_upload_submit(self, REQUEST=None):
		""" """
		
		if REQUEST.has_key('package_name'):
			pkgid = REQUEST['package_name']
		else: raise "No Package Upload found for Session"
			
		contract = compile(version_upload_contract)
		contract.validate(self)
		
		package_queue = self.get_inner_application(self).get_package_queue()
		package = package_queue._getOb(pkgid)
		version = package.get_version_container().get_current_version()
		id, title = cookId('','',REQUEST['distribution_file'])

		if not version.has_file(id):
			version.add_file(PackageFile(id, title))
			fobj = version._getOb(id)
			fobj.manage_upload(REQUEST['distribution_file'])

		return_url = self.get_inner_application(self).get_package_queue().absolute_url()			
		
		if REQUEST is not None:
			REQUEST.RESPONSE.redirect(return_url)


	def metadata_upload_submit(self, REQUEST):
		""" """

		contract = compile(metadata_upload_contract, self)
		contract.validate(self)
		
		rawinfo = self._parse_metadata_file(
			REQUEST['metadata_format'], REQUEST['metadata_file'])

		#print rawinfo
		pi = PackageInfo(info=rawinfo)		
		p  = Package(pi.package_name())
		pv = PackageVersion(rawinfo.get('version'))
		p.set_package_info(pi)
		
		print 'dump', rawinfo

		# this whole thing is a mess right now
		# it needs to reworked, packages shouldn't 
		# be added to the queue unless they have all
		# the req info. however doing some of the
		# object addition while in non rooted is
		# difficult for zope objects
		
		log.debug('Storing Package in Queue')		
		package_queue= self.get_inner_application(self).get_package_queue()
		package_queue.add_package(pi.package_name(), p)		

		p.get_version_container().add_version(pv)
		
		info_required = pi.get_remaining_required()
		version_required = pv.get_remaining_required()
		
		if info_required is None and version_required is None:

			redirect_url = ']'.join((package_queue.absolute_url(),
							         pi.package_name(),
							         'version_upload_form'
							         ))
			
			REQUEST.RESPONSE.redirect('version_upload_form'+'?package_name='+\
							pi.package_name())
			
		elif info_required is None and version_required is not None:
			REQUEST.RESPONSE.redirect('version_required_form')			
		elif info_required is not None:
			REQUEST.RESPONSE.redirect('metadata_required_form')						
		else: log.debug('Upload Error, shouldn" have gotten here')


		


	

	
