
from Products.Gideon.Objects.Namespace import *

_marker = []

class PackageVersionContainer(Folder):
	
	meta_type = 'Package Version Container'

	security = ClassSecurityInfo()

	index_html = None
	
	__call__ = DTMLFile('ui/PackageVersionContainerView', globals())
	
	security.declarePublic('version_list')
	version_list = DTMLFile('ui/PackageVersionContainerList', globals())
	
	def __init__(self, id):
		self.id = id
		self._cur_version = None

	security.declarePublic('get_global_dependencies')
	def get_global_dependencies(self):
		return self.objectValues('Package Dependency')

	security.declarePrivate('add_global_dependency')
	def add_global_dependency(self, depedency):
		self._setObject(depedency.getId(), depedency)

	security.declarePrivate('add_version')
	def add_version(self, version):
		if self._cur_version is None: 
			self._cur_version = version.id
		self._setObject(version.id, version)

	security.declarePublic('get_version')
	def get_version(self, version_id, default=_marker):
		version = self._getOb(version_id, default)
		if version is _marker:
			raise AttributeError("No such version %s"%version_id)
		return version

	security.declarePublic('get_versions')
	def get_versions(self):
		return self.objectValues('Package Version')
	
	### hmm. ideally this is an ordered list 

	security.declarePrivate('set_current_version')
	def set_current_version(self, vid):
		if vid in self.objectIds('Package Version'):
			self._cur_version = vid
		else: raise "Invalid Version Id"

	security.declarePublic('get_current_version')
	def get_current_version(self):
		if self._cur_version and self._cur_version in \
		   self.objectIds('Package Version'):
			return self._getOb(self._cur_version)
		
		elif self._cur_version is None and \
		     len(self.objectIds('Package Version')) ==1:
			return self.objectValues('Package Version')[0]
		
		elif self._cur_version is None and len(self.objectIds()) == 0:
			raise "No Versions"
		
		elif self._cur_version is None:
			raise "No current version Set"
		
		elif self._cur_version is not None:
			raise "Inconsistent Version State"


class PackageVersion(Folder):
	
	"""
	a version logically consists of 
	distribution files, a version id/name,
	and version specific dependencies
	
	"""
	meta_type = 'Package Version'

	security = ClassSecurityInfo()
	
	def __init__(self, id):
		self.id = id

	security.declarePrivate('get_remaining_required')
	def get_remaining_required(self): 
		""" hook method for versions created directly
		via metadata files to enforce schema constraints"""

	security.declarePrivate('add_dependency')
	def add_dependency(self, dependency):
		self._setObject(dependency.getId(), dependency)

	security.declarePrivate('remove_version')
	def remove_dependency(self, dependency_name):
		self._delObject(dependency_name)

	security.declarePublic('get_dependencies')
	def get_dependencies(self):
		""" """
		return self.objectValues('Package Dependency')

	security.declarePublic('get_files')
	def get_files(self):
		return self.objectValues(('File', 'Package File'))

	security.declarePublic('has_file')
	def has_file(self, fid):
		return fid in self.objectIds(('File', 'Package File'))

	security.declarePrivate('add_file')
	def add_file(self, file): 
		self._setObject(file.getId(), file)
		
