"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 this file is part of Gideon

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: Ratings.py,v 1.2 2002/02/23 01:37:57 ender Exp $

"""
  Ratings.py
"""
from AccessControl import ClassSecurityInfo, getSecurityManager
from BTrees.IIBTree import IIBTree
from BTrees.Length import Length
from Globals import  InitializeClass, DTMLFile
from OFS.SimpleItem import SimpleItem

manage_addRatingsForm = None

def manage_addRatings(self,
		      id='Ratings',
		      REQUEST=None
		      ):

	self._setObject(id, Rating(id))
	if REQUEST is not None:
		REQUEST.RESPONSE.redirect('manage_main')


class Rating(SimpleItem):

	id = 'Ratings'
	
	security = ClassSecurityInfo()

	security.declarePublic('__call__')# logical
	__call__ = DTMLFile('ui/RatingView', globals())
	
	index_html = None

	security.declarePublic('thank_you')
	thank_you  = DTMLFile('ui/RatingThankYou', globals())

	security.declarePublic('already_voted')
	already_voted = DTMLFile('ui/RatingAlreadyVoted', globals())
	
	_scale = 6 # means we allow votes from 1 to scale

	def __init__(self, id='Ratings'):
		self.id = id
		self._data = IIBTree()
		self._num_votes = Length(0)
		self._vote_sum = Length(0)

	security.declareProtected('Rate Content', 'add_rating')
	def add_rating(self, value=None, RESPONSE=None):
		""" """
		try:
			value = int(value)
		except:
			if RESPONSE is not None:
				return RESPONSE.redirect(
					self.get_content_path())
							 
		if value not in range(1, self._scale,1):
			
			if RESPONSE is not None:
				return RESPONSE.redirect(
					self.get_content_path())

		uname = getSecurityManager().getUser().getId()
		
		if uname == 'Anonymous User':
			return RESPONSE.redirect(self.get_content_path())

		if self._data.has_key(hash(uname)):
			return self.already_voted(self)
				
		self._data[hash(uname)]=int(value)
		self._num_votes.change(1)
		self._vote_sum.change(value)

		self.get_service('RatingService')._change_rating(self)
		
		if RESPONSE is not None:
			RESPONSE.redirect(self.get_content_path())
			

	security.declarePublic('getNumberVotes')
	def get_number_votes(self):
		""" """

		return self._num_votes()

	security.declarePublic('getCumulativeScore')
	def get_cumulative(self):
		""" """
		
		return self._vote_sum()
			
	security.declarePublic('getAverageRating')
	def get_average(self):
		""" return rating as string formated float """

		if self._num_votes():
			return 	"%1.1f"%(self._vote_sum()/float(
				                self._num_votes()))
		else: return 'N/A'

	security.declarePublic('getVoteUrl')
	def get_vote_url(self):
		
		return self.absolute_url()+'/add_rating'

	security.declarePrivate('get_content_path')
	def get_content_path(self):
		
		return '/'.join(self.aq_inner.aq_parent.getPhysicalPath())

	security.setPermissionDefault('Rate Content', ('Authenticated',))
	
InitializeClass(Rating)

