"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

"""
	requirements
	
	flat view list... options for sorting...
	
	perhaps doing some sort of 


"""

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.PageContract.Scripts import compile

from BTrees.OIBTree import OISet
from BTrees.IOBTree import IOBTree
from BTrees.Length import Length
from ZTUtils.Zope import make_query

class ReviewManager(SimpleItem, Implicit):
	
	meta_type = 'Review Manager'
	
	security = ClassSecurityInfo()
	
	security.declarePublic('index_html')
	index_html = DTMLFile('ui/ReviewManagerView', globals())

	security.declareProtected('Add Reviews', 'review_form')
	review_form    = DTMLFile('ui/ReviewForm', globals())

	security.declareProtected('Add Reviews', 'review_preview')
	review_preview = DTMLFile('ui/ReviewPreviewForm', globals())
	
	security.declarePublic('already_reviewed')
	already_review = DTMLFile('ui/RatingAlreadyVoted', globals()) 
	
	def __init__(self, id, title):
		self.id = id
		self.title = title
		self._reviews = OISet()
		self._length  = Length()
	
	security.declareProtected('Add Reviews', 'add_review')
	def add_review(self, REQUEST):
		contract = """
		#parameters
		review_title:trim, nohtml
		review_text:trim, nohtml
		"""
		contract = compile(contract)
		contract.validate(REQUEST)
	
	security.declarePublic('get_reviews')
	def get_reviews(self, limit=5, reverse=0):
		return self._reviews

	def __bobo_traverse__(self, REQUEST, name): 
		ob = getattr(self, name, None)
		if ob: return ob
		
		

InitializeClass(ReviewManager)	
	
class Review(SimpleItem, Implicit):
	
	meta_type = 'Review'

	security = ClassSecurityInfo()
	security.declareObjectPublic()
	
	index_html = DTMLFile('ui/ReviewView',globals())
	
	def __init__(self, id, title, review_text):
		self.id = id
		self.title = title
		self.review_text = review_text
		
	__call__ = DTMLFile('ui/ReviewRenderEmbedded', globals())
		
InitializeClass(Review)		
