"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from Products.Gideon.Objects.Namespace import *

from Products.Gideon.Objects.UserDirectory.Collaborators \
     import BaseCollaborator

class SubscriptionManager(BaseCollaborator, Folder):
    """

    provides for user management of their subscriptions
    
    """
    
    security = ClassSecurityInfo()
    
    meta_type = 'Subscriptions Collaborator'

    _default_panel_name = 'subscription_panel'
    _default_widget_name = 'subscription_widget'    
    
    subscription_panel = DTMLFile('ui/SubscriptionCollaboratorView',
                                  globals())
    
    subscription_widget = DTMLFile('ui/SubscriptionCollaboratorWidget',
                                   globals())
        

    def __init__(self, id, title):
        self.id = id
        self.title = title

    def add_subscription(self, subscription_id, subscription):
        
        self._setObject(subscription_id, subscription)
    
    def remove_subscription(self, subscription_id):
        
        self._delObjects([subscription_id])
    
    def get_subscriptions(self):
        
        return self.objectValues('Subscription')
    
    def deactivate_all(self):
        
        for v in self.objectValues('Subscription'):
            
            v.deactivate()

    def activate_all(self):

        for v in self.objectValues('Subscription'):
            
            v.activate()
