"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

class SubscriptionManager(BaseCollaborator):
    """
    provides for user management of their subscriptions
    """

    security = ClassSecurityInfo()
    
    meta_type = 'Subscriptions Collaborator'

    _default_panel_name = 'subscription_panel'
    _default_widget_name = 'subscription_widget'    
    
    subscription_panel = DTMLFile('ui/SubscriptionCollaboratorView',
                                  globals())
    
    subscription_widget = DTMLFile('ui/SubscriptionCollaboratorWidget',
                                   globals())
        
    def add_subscription(self, subscription_id, subscripion):
        
        self._data[id] = subscription
    
    def remove_subscription(self, subscription_id):
        
        if self._data.has_key(subscription_id):
            
            del self._data[subscription_id]
    
    def get_subscriptions(self):
        
        return self._data.values()
    
    def deactivate_all(self):
        
        for v in self._data.values():
            
            v.deactivate()

    def activate_all(self):

        for v in self._data.values():
            
            v.activate()
