"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from Products.Gideon.Objects.Namespace import *

from Products.Gideon.Objects.Application.ApplicationObject \
     import ApplicationObject

class SubscriptionDelegate(SimpleItem):
    """
    This class provides a useful interaction between users and 
    objects they wish to subscribe to.
    """

    subscription_registration_form =DTMLFile('ui/SubscriptionRegistrationForm',
                                             globals())
                                              
    def __call__(self, REQUEST):
        """ """
        obj = REQUEST.parents.pop()

        subservice = self.get_service("SubscriptionService")

        subtypes = subservice.get_subscription_types_for_object(obj)
        
        return self.subscription_registration_form(self,
                                                   REQUEST,
                                                   subtypes=subtypes)

    def register_subscription(self, REQUEST):
        
        contract = """
        """
        
        #contract = compile(contract)
        v = contract.extract_variables(REQUEST)
        
        user_id = getSecurityManager().getUser().getId()
        
        subservice = self.get_service("SubscriptionService")

        submanager = subservice.get_subscription_manager_for_user(user_id)

        subscription_id = v.subscription_id
        
        subscription = Subscription(
                          subscription_id,
                          v.event_type,
                          v.location,
                          v.period
                          )

        submanager.add_subscription(subscription_id,  subscription)

class SubscriptionService(ApplicationObject,ObjectManager):

    """
    provides system wide management of subscriptions
    """

    security = ClassSecurityInfo()
    
    meta_type = 'Subscription Service'

    def __init__(self, id, title=''):
        
        self.id = id
        self.title = title

    security.declarePrivate('get_subscription_manager_for_user')
    def get_subscription_manager_for_user(self, user_id=None):
        pass

    security.declarePrivate('get_subscription_types_for_object')
    def get_subscription_types_for_object(self, object):
        pass

    
