"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $


from Products.Gideon.Objects.Namespace import *

from Products.Gideon.Objects.Application.ApplicationObject \
     import ApplicationObject

from Products.Gideon.Objects.UserDirectory.Collaborators \
     import BaseCollaborator


class Subscription(SimpleItem):
    
    """

    Denotes a user subscription

    """
    meta_type = 'Subscription'
    
    security = ClassSecurityInfo()

    allowed_periods = ('day', 'week', 'month')
    
    def __init__(self, id, event_type, location, period, filter_name):
        
        self.id = id
        self.status = 1
        self.filter_name = filter_name
        self.location = location
        self.period = period
        self.creation_date = DateTime()

    def set_period(self, period):
        
        if period not in self.allowed_periods: return
        self.period = period
        
    def set_active(self, active):
        
        self.active = active

    def get_history(self): pass

    
    
    
    
