"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from BTrees.IOBTree import IOBTree

from Products.ZCatalog.ZCatalog import ZCatalog

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log  import LogFactory
from Products.Gideon.Objects.Catalog import CatalogSchema
from Products.Gideon.Objects.Application.PythonRepository \
     import RepositoryApplication
from Products.Gideon.PageContract.Scripts import compile

from TrackerSchema import MetaIssueSchema

log = LogFactory('Tracker')

class Tracker(RepositoryApplication):
    
    meta_type = 'Issue Tracker'

    security = ClassSecurityInfo()

    security.declarePublic('index_html')
    index_html = DTMLFile('ui/TrackerView', globals())

    security.declareProtected('Add Tracker Issue', 'add_issue_form')
    add_issue_form = DTMLFile('ui/TrackerAddIssueForm', globals())



    def __init__(self, id, title=''):
        self.id = id
        self.title = title

    security.declareProtected('Admin Tracker', 'set_tracker_schema')
    def set_tracker_schema(self, schema):
        self._schema = schema.getPhysicalPath()

    security.declarePublic('get_tracker_schema')
    def get_tracker_schema(self):
        return self.unrestrictedTraverse(self._schema)

    security.declareProtected('Add Tracker Issue', 'add_issue')
    def add_issue(self, REQUEST, noredirect=0):
        """ """
        issue_id = REQUEST['issue_id']

        if issue_id in self.objectIds('Issue'):
            if noredirect: return
            else: return REQUEST.RESPONSE.redirect('.')

        user_id = getSecurityManager().getUser().getId()
        
        issue = Issue(issue_id, user_id)
        self._setObject(issue_id, issue)

        # set the default state
        REQUEST.set('state', self.get_schema().get_initial_state())
        
        issue = self._getOb(issue_id)
        issue.edit_issue(REQUEST=REQUEST, no_publish=1, noredirect=1)
            
        channel = self.get_service("EventChannel")
        channel.publish(issue, "Tracker Issue Added")

        if not noredirect:
            REQUEST.RESPONSE.redirect('.')

    def get_schema(self):
        return self.Schema

    def manage_afterAdd(self, item, container):
        
        channel = item.get_service("EventChannel")

        channel.register_event_type("Tracker Issue Added")
        channel.register_event_type("Tracker Issue Modified")
        channel.register_event_type("Tracker Listen")
        
        channel.register_event_mapping(
            source="Tracker Issue Added",
            targets=["Tracker Listen"]
            )
        channel.register_event_mapping(
            source="Tracker Issue Modified",
            targets=["Tracker Listen"]
            )

        IssueSchema = MetaIssueSchema('Schema')
        CatalogSchema.install_catalog_schema('IssueCatalog',
                                      IssueSchema.get_catalog_schema(),
                                      self)

        self._setObject('Schema', IssueSchema)
        
        Folder.manage_afterAdd(self, item, container)

InitializeClass(Tracker)

class Issue(Folder):

    meta_type = 'Issue'

    security = ClassSecurityInfo()

    security.declarePublic('index_html')
    index_html = DTMLFile('ui/IssueView', globals())

    security.declareProtected('Add Tracker Issue Comments', 'add_comment_form')
    add_comment_form = DTMLFile('ui/IssueAddCommentForm', globals())


    security.declareProtected('Edit Tracker Issue', 'edit_form')
    edit_form = DTMLFile('ui/IssueEditForm', globals())
    
    assigned_user = None
    
    def __init__(self, id, created_by):
        self.id = id
        self.creation_date = DateTime()
        self.creation_by   = created_by
        self.assigned_user = None

    security.declareProtected('Edit Tracker Issues', 'edit_issue')
    def edit_issue(self, REQUEST, no_publish=0, noredirect=0):
        """
        """
        tracker = self.get_inner_application(self)
        schema = tracker.get_schema()
        log.debug('state '+REQUEST.state)
        schema.validate_vars(REQUEST)
        
        info = schema.extract_vars(REQUEST)

        self.__dict__.update(info.as_dict())
        self._p_changed = 1 

        if not no_publish:
            channel = self.get_service("EventChannel")
            channel.publish(self, "Tracker Issue Modified")

        if not noredirect:
            REQUEST.RESPONSE.redirect('.')

    security.declareProtected('Edit Tracker Issues', 'assign_user')
    def set_assigned_user(self, user_id=None, REQUEST=None):
        """
        hello
        """
        
        if user_id is None:
            user_id = getSecurityManager().getUser().getId()
        else:
            uw = self.get_application_for_name('Members').get_user_workspace(
                user_id,
                None)

            if uw is None: raise "Invalid User"

        if self.assigned_user is not None: pass
        
        self.assigned_user = user_id

        if REQUEST is not None: REQUEST.RESPONSE.redirect('.')

    security.declarePublic('get_assigned_user')
    def get_assigned_user(self):
        
        return self.assigned_user 

    security.declareProtected('Add Tracker Issue Comments', 'add_comment')
    def add_comment(self, REQUEST):
        """
        """
        log.debug('adding comment')
        
        contract = """
        #parameters
        comment_id: trim
        comment_title: trim, nohtml
        comment_text: trim, nohtml
        """
        
        contract = compile(contract, self)
        contract.validate(REQUEST)
        v = contract.extract_variables(REQUEST)

        user_id = getSecurityManager().getUser().getId()

        log.debug('comment id '+v.comment_id)
        
        comment = IssueComment(v.comment_id,
                          user_id,
                          v.comment_title,
                          v.comment_text)
        
        self._setObject(v.comment_id, comment)
        
        channel = self.get_service("EventChannel")
        channel.publish(self, "Tracker Issue Modified")

        REQUEST.RESPONSE.redirect('.')

InitializeClass(Issue)

class IssueComment(SimpleItem):

    meta_type = 'Issue Comment'

    index_html = None

    render_widget = DTMLFile('ui/IssueCommentWidget', globals())

    def __init__(self, id, user_id, title, body):
        self.id = id
        self.user_id = user_id
        self.title = title
        self.body = body
        self.creation_date = DateTime()

    def __call__(self):
        pass

