"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.PageContract.Scripts import compile
from Products.Gideon.Objects.Catalog.CatalogSchema import CatalogSchema

class MetaIssueSchema(SimpleItem):
    """

    this really wants to use formulator to auto generate forms...
    
    """
    # constraints for page contract
    c_type = ['bug', 'feature']

    c_component = ['membership',
                 'subscriptions',
                 'packages',
                 'authors',
                 'categories',
                 'search',
                 'infrastructure']

    c_state = ['open', 'closed', 'accepted', 'rejected']

    c_priority = ['urgent', 'normal', 'low']
    
    indexes = { 'component':'FieldIndex',
                'type':'FieldIndex',
                'state':'FieldIndex',
                'priority':'FieldIndex',
                }

    columns = ['component', 'type', 'state',  'priority']

    page_contract = """
    #parameters
    component: constraint(c_component)
    type: constraint(c_type)
    priority: constraint(c_priority)
    state: optional,constraint(c_state)
    body: trim, nohtml
    title: trim, nohtml
    """
    
    contract = compile(page_contract)
    catalog_schema = CatalogSchema(indexes, columns)

    def __init__(self, id):
        self.id = id
            
    def extract_vars(self, REQUEST):
        return self.contract.extract_variables(REQUEST)

    def validate_vars(self, REQUEST=None, **kw):
        return self.contract.validate(self)

    def get_catalog_schema(self):
        return self.catalog_schema

    def get_initial_state(self):
        return self.c_state[0]



