"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from AccessControl.User import UserFolder, User
from AccessControl import ClassSecurityInfo
from BTrees.OOBTree import OOBTree
from BTrees.Length import Length
from Globals import DTMLFile, InitializeClass
from Interface import Base
from Products.ZCatalog.ZCatalog import ZCatalog

from Products.Gideon.Objects.Application.PythonRepository import RepositoryApplication
from Products.Gideon.Log.Log import log
from Products.Gideon.PageContract.Scripts import compile

## interfaces for a user

class IRepositoryUser(Base):
    """
    the repository user, it exposes
    the same interface as a normal user
    in addition though it also
    """
    
    def get_user_name(self): 
        """ return the users name (not id) """
    
    def get_id(self):
        """ return the users id """
    
    def get_workspace(self): 
        """ get the POS for this user """


class IBTreeUserFolder(Base): 
    """ 
    a minor mod to the basic user folder to use
    a btree for user storage. it supports
    all the normal interfaces of a userfolder
    *except* you can don't get multiple users
    from it in a single call. to search or find
    (multiple) users the search interfaces
    for the UserDirectory should be used.
    """

class RepositoryUser(User): 
    
    __implements__ = (IRepositoryUser,)
    
    def get_user_name(self):
        # delegate to user storage
        self.get_workspace().get_user_name()
    
    def get_id(self):
        return self.getId()
    
    def get_workspace(self):
        directory = self.get_application_for_name('Members')
        return directory.get_user_workspace(self.get_id())
        

class BTreeUserFolder(UserFolder):
    
    meta_type = 'User Folder'
    id = 'acl_users'
    title = 'BTree User Folder'
    
    encrypt_passwords = 1
    
    def __init__(self):
        self.data = OOBTree()
        
    def _doAddUser(self, name, password, roles, domains, **kw):
        """Create a new user"""
        
        if password is not None and self.encrypt_passwords:
            password = self._encryptPassword(password)
        self.data[name]=RepositoryUser(name,password,roles,domains)
        
    ## public interface overides

    def getUserNames(self):
        """Return a list of usernames"""
        #names = self.data.keys()
        #return names
        return []

    def getUsers(self):
        """Return a list of user objects"""        
        #return self.data.values()
        return []