"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.PageContract.Scripts import compile
from ICollaborator import IWorkspaceCollaborator

class BaseCollaborator(SimpleItem):
    
    __implements__ = (IWorkspaceCollaborator,)

    _default_panel_name = ''
    _default_widget_name = ''
    
    def __init__(self, id, title):
        self.id = id
        self.title = title
    
    def get_panel_name(self): 
        return self._default_panel_name
    
    def get_widget_name(self):
        return self._default_widget_name

    
class PackageManagementCollaborator(BaseCollaborator):
    
    meta_type = 'Package Management Collaborator'
    
    _default_panel_name = 'package_panel'
    _default_widget_name = 'package_widget'
    
    package_panel = DTMLFile('ui/PackageCollaboratorView', globals())
    package_widget = DTMLFile('ui/PackageCollaboratorWidget', globals())

class SubscriptionCollaborator(BaseCollaborator):
    
    meta_type = 'Subscriptions Collaborator'
    
    _default_panel_name = 'subscription_panel'
    _default_widget_name = 'subscription_widget'
    
    subscription_panel = DTMLFile('ui/SubscriptionCollaboratorView',
                                  globals())
    
    subscription_widget = DTMLFile('ui/SubscriptionCollaboratorWidget',
                                   globals())

        
"""
_collaborator_factory =  {}

def register_factory(self, name, klass):
    _collaborator_factory[name]=klass
"""    
    
    
