"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from AccessControl.User import UserFolder, User
from AccessControl import ClassSecurityInfo
from BTrees.OOBTree import OOBTree
from BTrees.IOBTree import IOBTree
from BTrees.Length import Length
from ExtensionClass import Base
from Globals import DTMLFile, InitializeClass
from ZTUtils.Zope import make_query
from Products.ZCatalog.ZCatalog import ZCatalog


from Products.Gideon.Objects.Application.PythonRepository \
     import RepositoryApplication
from Products.Gideon.Objects.Catalog import CatalogSchema
from Products.Gideon.Log.Log import LogFactory
from Products.Gideon.PageContract.Scripts import compile

from IUserDirectory import IUserDirectory
from UserWorkspace import UserWorkspace

_marker = []

log = LogFactory('UserDirectory')

user_indexes = {
    'first_name': 'TextIndex',
    'last_name': 'TextIndex',
    'email':'TextIndex',            
    'groups':'KeywordIndex',
    'SearchableText':'TextIndex'
}    

user_columns = ['first_name', 'last_name', 'email', 'groups' 'path']

user_schema = CatalogSchema.CatalogSchema(user_indexes, user_columns)

from Acquisition import aq_inner, aq_parent, aq_base

def nearest_obj(self, name, wrap=1):
   """ 
   return the nearest object named name 
   if wrap is true than return the object
   with an acquisition wrapper
   """
   candidiate = aq_inner(self)
   
   while 1:
      target = getattr(aq_base(candidiate), name)
      if target: 
         if wrap: return getattr(candidiate, name)
         else: return target
         
      candidiate = aq_parent(candidiate)
      if candidiate is None: return None
   
class UserDirectory(RepositoryApplication):

    meta_type = 'User Directory'
    
    __implements__ = (IUserDirectory,)

    security = ClassSecurityInfo()
    
    security.declarePublic('index_html')
    index_html = DTMLFile('ui/DirectoryView', globals())
    
    security.declarePublic('user_search_form')
    user_search_form = DTMLFile('ui/DirectorySearchForm', globals())
    
    security.declarePublic('login_form')
    login_form = DTMLFile('ui/DirectoryLoginForm', globals())
    
    security.declarePublic('logged_out')
    logged_out = DTMLFile('ui/DirectoryLogoutView', globals())
    
    security.declarePublic('register_form')
    register_form = DTMLFile('ui/DirectoryRegisterForm', globals())
    
    
    def __init__(self, id, title):
        self.id = id
        self.title = title
        self.data = OOBTree()

    security.declarePublic('login_url')
    def login_url(self):
        return '/'.join((self.absolute_url(), 'login_form'))

    security.declarePublic('logout_url')
    def logout_url(self):
        return '/'.join((self.get_root_application(), 'logout'))
    
    security.declarePublic('dispatch')
    def dispatch(self, REQUEST):
        """ """
        user = self.REQUEST.AUTHENTICATED_USER
        id = user.getId()

        if id is None: return REQUEST.RESPONSE.redirect(self.login_url())

        if REQUEST.has_key('return_url'):
           return_url = REQUEST['return_url']
           del REQUEST.form['return_url']
           del REQUEST.form['retry']
           return_url = "%s?%s"%(return_url, make_query(REQUEST.form))

           return REQUEST.RESPONSE.redirect(return_url)

        workspace = self.get_user_workspace(id, None)
        
        if workspace is None: # add one by default
            workspace = self.add_user_workspace(user)

        REQUEST.RESPONSE.redirect(workspace.absolute_url())
    
    security.declarePublic('register_user')
    def register_user(self, REQUEST):
        """ """
        contract = """
        #parameters
        first_name:optional, trim
        last_name:optional, trim
        user_name: newuid, minsize(4), maxsize(10)
        user_password:pwd_confirm(user_password_confirm)
        """
        contract = compile(contract, self)
        contract.validate(self)

        vars = contract.extract_variables(REQUEST)
        acl_users = self.acl_users

	print acl_users.getPhysicalPath()

	acl_users._doAddUser(
		vars['user_name'],
		vars['user_password'], 
		['Member'],
		[]
		)
	return REQUEST.RESPONSE.redirect('dispatch')
        
    security.declarePrivate('add_user_workspace')
    def add_user_workspace(self, user):
        """ """
        id  = user.getId()
        if self.data.has_key(hash(id)): raise "User Workspace already exists"
        
        self.data[hash(id)]=UserWorkspace(id, id)
        workspace = self.data.get(hash(id)).__of__(self)        
        workspace.manage_afterAdd(workspace, self)
        
        catalog = self.get_service("UserCatalog")
        catalog.catalog_object(workspace)
        
        return workspace
    
    security.declarePrivate('get_user_workspace')
    def get_user_workspace(self, user_id, default=_marker):
        """ """
        workspace = self.data.get(hash(user_id), default)
        if workspace is not default: 
            return workspace.__of__(self)
        elif workspace is _marker:
           raise AttributeError("Workspace for %s not found"%user_id)
        return default

    security.declarePrivate('get_user_workspace')
    def get_current_workspace(self):
       """ """
       # need to think abourt error modes a little more
       
       user_id = getSecurityManager().getUser().getId()

       if user_id == 'Anonymous User':
          return None

       return self.get_user_workspace(user_id, None)
       

    def __bobo_traverse__(self, REQUEST, name):
        ob = getattr(self, name, None)
        if ob is not None: return ob
        ob = self.get_user_workspace(name, None)
        if ob is not None: return ob
        raise "NotFound"

    security.declarePublic('search_users')
    def search_users(self, SearchableText):
       """ """
       user_catalog = self.get_service("UserCatalog")
       res = user_catalog(SearchableText=SearchableText)
       log.debug('Search %s'%str(res.__dict__))
       return res
    
    security.declarePrivate('manage_afterAdd')
    def manage_afterAdd(self, item, container):
        ## add in catalog
        CatalogSchema.install_catalog_schema('UserCatalog', user_schema, self)
        ## register proxy
        ## add in event queues

InitializeClass(UserDirectory)        
