"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $


from Products.Gideon.Objects.Namespace import *
from Products.Gideon.PageContract.Scripts import compile
from ICollaborator import IWorkspaceCollaborator
from Collaborators import BaseCollaborator

class UserInformationCollaborator(BaseCollaborator):
    
    """
    this class provides access and mutability to
    a user's personal information. it also
    sets
    """
    
    
    meta_type = 'User Information Collaborator'
    
    _default_panel_name = 'info_panel'
    _default_widget_name = 'info_widget'
    
    info_panel = DTMLFile('ui/InfoCollaboratorView', globals())
    info_widget = DTMLFile('ui/InfoCollabortorWidget', globals())

    def __init__(self,
                 id,
                 title,
                 user_id,
                 first_name='',
                 last_name='',
                 public_email='',
                 city='',
                 country=''
                 ):

        self.id = id
        self.title = title

        self.user_id = user_id
        
        self.first_name = first_name
        self.last_name = last_name
        self.public_email = public_email
        self.city = city
        self.country = country
    
    def workspace_url(self): pass
        

    def edit_profile(self, REQUEST):
        """
        """
        contract = """
        #parameters
        first_name: trim
        last_name: trim
        public_email: trim
        city: trim, optional
        country: trim, optional
        """

        contract = compile(contract, self)
        contract.validate(REQUEST)

        directory = self.get_application_for_name('UserDirectory')

        """
        workspace = directory.get_user_workspace(
                         getSecurityManager().getUser().getId())
        """

        catalog = directory.get_service("UserCatalog")

        catalog.catalog_object(self)
        
        
