"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from AccessControl import ClassSecurityInfo, getSecurityManager
from OFS.Folder import Folder
from Globals import DTMLFile, InitializeClass
from ZODB.PersistentMapping import PersistentMapping

from Products.ZCatalog.ZCatalog import ZCatalog
from Products.Gideon.Log.Log import log
from Products.Gideon.PageContract.Scripts import compile

from ICollaborator import IWorkspaceCollaborator
from IWorkspace import IUserWorkspace

_marker = []

class CollaboratorNotFound(AttributeError): pass

class UserWorkspace(Folder):
    
    meta_type = 'User Workspace'
    
    __implements__ = (IUserWorkspace,)
    
    security = ClassSecurityInfo()
    
    index_html = DTMLFile('ui/WorkspaceView', globals())
    
    _panel_container = DTMLFile('ui/WorkspacePanelViewer', globals())
    
    def __init__(self, id, title):
        self.id = id
        self._collaborators = PersistentMapping()

    def user_name(self):
        
        return self.getId() # cheese
        
    def get_collaborator_names(self):
        
        return self._collaborators.keys()

    def get_collaborator_for_name(self, name):

        collaborator_path = self._collaborators.get(name, None)

        if collaborator_path is None:
            raise CollaboratorNotFound(
                " No Collaborator found for name %s"%str(name)
                )

        return self.unrestrictedTraverse(collaborator_path)
        
    def get_collaborators(self):

        res = []
        for collaborator in self.get_collaborator_names():
            res.append(self.get_collaborator_for_name(collaborator))
        return res              
                       
    def panel(self, name, REQUEST):
        """ name == colloborator name """

        obj = self.get_collaborator_for_name(name)
        method = getattr(obj, obj.get_panel_name())
        
        rendered_panel =  method(obj, REQUEST) 

        return self._panel_container(self,
                                     REQUEST,
                                     rendered_panel=rendered_panel)
        
    def register_workspace_collaborator(self, collaborator):
        
        if not IWorkspaceCollaborator.isImplementedBy(collaborator):
            print collaborator, collaborator.__implements__
            raise "Invalid Application Registration For Workspace"
        
        self._collaborators[collaborator.getId()]=\
                                  '/'.join(collaborator.getPhysicalPath())
        
        log.debug('registering collaborator %s'%str(collaborator))


    def __bobo_traverse__(self, REQUEST, name):
        
        ob = getattr(self, name, None)
        if ob is not None: return ob
        ob = self.get_collaborator_for_name(name)
        if ob is not None: return ob
        raise "NotFound"        
        
    def SearchableText(self):
        """ for cataloging """
        return "%s"%self.getId()

    def manage_afterAdd(self, item, container):
        # register default collabs
        workspace_install_default_collaborators(self)
 
    def update(self):
        """ """
    
def workspace_install_default_collaborators(self):

    import Collaborators
    import UserInformationCollaborator
    
    from Products.Gideon.Objects.Subscriptions.SubscriptionCollaborator \
         import SubscriptionManager
    
    
    INFO_ID = 'ProfileManager'
    INFO_TITLE = 'Profile'


    SUB_ID = 'SubscriptionsManager'
    SUB_TITLE = 'Subscriptions'    

    
    PACK_ID = 'PackageManager'
    PACK_TITLE = 'Packages'



    ob = UserInformationCollaborator.UserInformationCollaborator(INFO_ID, 
                                                                 INFO_TITLE,
                                                                 self.getId())
    self._setObject(INFO_ID,ob)
    ob = self._getOb(INFO_ID)
    self.register_workspace_collaborator(ob)
    
    ob = SubscriptionManager(SUB_ID, SUB_TITLE)
    self._setObject(SUB_ID, ob)
    ob = self._getOb(SUB_ID)
    self.register_workspace_collaborator(ob)

    ob = Collaborators.PackageManagementCollaborator(PACK_ID, PACK_TITLE)
    self._setObject(PACK_ID, ob)
    ob = self._getOb(PACK_ID)
    self.register_workspace_collaborator(ob)
    
        
        
        
