"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log.Log import LogFactory

log = LogFactory("WebServices")

class IServiceAdapter(Base):

    """
    Service Adapters provide protocol specific handling,
    when a particular method/service is requested at
    on a protocol, the adapter handles the protocol
    and queries the broker for the service, and invokes
    it handling the protocol encoding of the response back to the
    client. services in gideon tend to be uri based, so most
    services will also implement a bobo_traverse to intercept
    services requests on their protcol.
    """
    
    def protocol(self):
        """ 
        return the procotol the adaptor services
        """
        
class ServiceAdapter(SimpleItem):
    
    meta_type = 'Service Adapter'
    
    __implements__ = (IServiceAdapter,)
    
    _protocol = None
    
    def __init__(self, id):
        self.id = id

    def protocol(self):
        return self._protocol
        
    def manage_afterAdd(self, item, container):
        """ """
        broker = self.get_inner_application(self)
        broker.register_adaptor(self, self._protocol)

class XMLRPCServiceAdapter(ServiceAdapter):
    
    _protocol = 'XMLRPC'
    
    def __bobo_traverse__(self, REQUEST, name=None):

        log.debug('handling request on %s'%self._protocol)
        
        broker = self.get_inner_application(self)
        provider = broker.get_provider(method_name=name)
        
        if provider is not None:
            return getattr(provider, name)

        return getattr(self, name)

class SOAPServiceAdapter(ServiceAdapter):
    
    _protocol = 'SOAP'
    
class SwallowServiceAdapter(ServiceAdapter):
    
    _protocol = 'Swallow'
    
    
    
