"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

import inspect

from ZODB.PersistentMapping import PersistentMapping

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log.Log import LogFactory
from Products.Gideon.Objects.Application.PythonRepository \
     import RepositoryApplication

from IServiceBroker import IServiceBroker
from ServiceDescriptor import ServiceDescriptor, ServiceProviderDescriptor

log = LogFactory("WebServices")

class ServiceBroker(ObjectManager):
    
    # ideally this would overide bobo traverse to allow
    # for adaptors to live non contained, but as is
    # thats not needed yet, so the current implementation
    # lets only providers live non local
    
    meta_type = 'Service Broker'
    
    __implements__ = (IServiceBroker,)

    security = ClassSecurityInfo()

    security.declarePublic('index_html')
    index_html = DTMLFile('ui/RepositoryBrokerView',globals())
    
    def __init__(self, id):
        self.id = id
        self.protocols = PersistentMapping()
        self.methods   = PersistentMapping()
    
    security.declarePrivate('register_provider')
    def register_provider(self, provider, provider_methods):
        
        provider_path = '/'.join(provider.getPhysicalPath())
        
        for m in provider_methods:
            
            if self.methods.has_key(m):
                log.warning('Service Broker : overiding method registeration')
            
            self.methods[m]=provider_path
        
            
    security.declarePrivate('register_adaptor')                
    def register_adaptor(self, adaptor, protocol_name):
        
        adaptor_path = '/'.join(adaptor.getPhysicalPath())
        
        if self.protocols.has_key(protocol_name):
            log.warning('Service Broker: overiding protocol registeration')
            
        self.protocols[protocol_name]=adaptor_path

    security.declarePublic('get_provider_info')
    def get_provider_info(self):
        """
        inspects the provider methods and returns a list of
        function description objects wrapped in a provider
        descriptor
        """
        res = {}
        
        for method, path in self.methods.items():
            
            provider_descriptor, provider = res.get(path, (None,None))
            
            if provider is None:
                provider = self.unrestrictedTraverse(path)
                provider_descriptor = \
                        ServiceProviderDescriptor(provider.name).__of__(self)
                
                res[path]=(provider_descriptor, provider)
                
            methodobj = getattr(provider, method)
            
            descriptor = ServiceDescriptor(method,
                                           inspect.getdoc(methodobj),
                                           inspect.getargspec(
                methodobj.im_func)[:1][0][1:]
                                           ).__of__(self)


            provider_descriptor.append(descriptor)

        # print provider_descriptor[0]()
        results = [d for d,p in res.values()]
        # print results
        res.clear()
        
        return results

    security.declarePublic('get_adapter_info')
    def get_adaptor_info(self):
        return self.protocols.items()

    security.declarePrivate('get_provider')
    def get_provider(self, method_name):
        
        provider_path = self.methods.get(method_name)
        return self.unrestrictedTraverse(provider_path)
    
    security.declarePrivate('get_adapter')    
    def get_adapter(self, protocol_name):

        adapter_path = self.protocols.get(protocol_name)
        return self.unrestrictedTraverse(protocol_name)

    def clear(self):
        """ """
        self.methods.clear()
        return 1
        
class RepositoryServiceBroker(RepositoryApplication, ServiceBroker): 
    
    index_html = DTMLFile('ui/RepositoryBrokerView',globals())
    
    def _install_defaults(self):
        
        from ServiceAdapter import XMLRPCServiceAdapter
        ob = XMLRPCServiceAdapter('xmlrpc')
        self._setObject('xmlrpc', ob)
        
        from ServiceProvider import RepositoryServiceProvider
        ob = RepositoryServiceProvider('provider')
        self._setObject('provider', ob)
        
        
    
    
    
        
        
        
