"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

from UserList import UserList
from Globals import DTMLFile
from Acquisition import Implicit

class ServiceProviderDescriptor(Implicit, UserList): 

    __allow_access_to_unprotected_subobjects = 1

    __call__ = DTMLFile('ui/ServiceProviderDescriptor', globals())

    def __init__(self, name):
        self.name = name
        init = ServiceProviderDescriptor.inheritedAttribute('__init__')
        init(self)

    def get_descriptors(self):
        return self.data


class ServiceDescriptor(Implicit):

    __allow_access_to_unprotected_subobjects = 1

    __call__ = DTMLFile('ui/ServiceDescriptorView',globals())

    def __init__(self, name, doc, args):
        self.name = name
        self.doc  = doc
        self.args = ', &nbsp;'.join(args)
