"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from ZODB.PersistentMapping import PersistentMapping

from Products.Gideon.Objects.Namespace import *
from Products.Gideon.Log import LogFactory


log = LogFactory("WebServices")

class IServiceProvider(Base):
    
    def methods(self):
        """ return the method names this provider provides """
        
        
class ServiceProvider(SimpleItem):
    
    meta_type = 'Service Provider'
    
    __implements__ = (IServiceProvider,)

    _methods = ()
    
    def __init__(self, id):
        self.id = id
        
    def manage_afterAdd(self, item, container):
        broker = self.get_inner_application(self)
        broker.register_provider(self, self._methods)

class RepositoryServiceProvider(ServiceProvider):
    
    _methods = ('search_packages',
                'get_package_info',
                'get_author_info')

    name = 'Repository WebServices'

    def search_packages(self, query):
        """ 
        search packages returns a list 
        consisting of package_ids
        """

        log.debug('handling service search packages %s'%str(query))
        
        query = check_query(query)

        query_dict['SearchableText']=query
        
        package_container = self.get_application_for_name("Packages")

        catalog = package_container.get_service("PackageCatalog")

        res = catalog(**query_dict)
        
        if res:
            return [r.package_name for r in res]
        else:
            return []
    
    def get_package_info(self, package_id):
        """
        returns a dictionary of consisting of a
        packages info
        """

        log.debug("retrieving package info %s"%str(package_id))

        query = check_query(package_id)

        query_dict['package_id']=package_id

        package_container = self.get_application_for_name("Packages")

        package_container = self.get_application_for_name("Packages")

        catalog = package_container.get_service("PackageCatalog")

        res = catalog(**query)

        if res:
            return [r.package_url for r  in res]
        else:
            return []


    def search_authors(self, query, REQUEST):
        pass
    
    def get_author_info(self, author_id):
        """
        returns a list of package_ids by
        an author
        """
        query = {}
        query['package_author']=author_id
        package_container = self.get_application_for_name("Packages")

        try:
            res = map(lambda x: x.package_name,
                      package_container.search_packages(query))
        except:
            return []
        return res

def check_query(query):
    return query
