"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

# Author: kapil thangavelu <kvthan@wm.edu>
# License: GPL
# Purpose: Install all the Repository Objects
# Cvs: $Id $
  
import os
import Application

from App.Common import package_home

def initialize(context):

    objects_directory = package_home(globals())
    object_packages = [op for op in os.listdir(objects_directory) \
                       if os.path.isdir(os.path.join(objects_directory,op))]
    
    canonical_root = 'Products.Gideon.Objects'
    canonical_from = ['Products','Gideon','Objects']

    for p in object_packages:  

        if p == 'CVS': continue 

        try:
            p_mod  = __import__(p, globals(), locals(),canonical_from)
        except:
            print 'error  on ', p
            import sys, traceback
            print traceback.print_exc(sys.exc_info())
            continue
            
        p_init = getattr(p_mod, 'initialize', None)
        
        if p_init is not None:
            p_init(context) 



