"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from string import split, strip, index, count
from Filters import sort_filters, filters, filter_keys
from Exceptions import SyntaxError, FilterNotSupportedError

DEBUG = 0

def extract_contract(contract):
    """ doesn't do anythin currently because i haven't thought
    of a good way to automate extraction of this information.... """
    
    if DEBUG: print "v blocks", contract._v_blocks
    pass

def extract_errors(errors, strip=strip, split=split):
    """
    extracts per variable handlers from the exceptions section of
    dtml-contract. handlers are listed with form
    var_name:handler
    or
    default_handler
    
    handlers are called when errors arise during validation
    from the application of filters. default handlers catch errors
    for any variable which does not have its own error handler.
    
    @param errors the enclosed <dtml-exceptions> </dtml-contract> section
    of a dtml-contract.
    @param strip minor speedup by placing string.strip in locals
    @param split minor speedup by placing string.split in locals
    @return e_handles a dictionary of var_name->error_handler
    @throws Syntax Error if exceptions section is not well-formed
    """

    if DEBUG: print "Parsing Errors"
    
    if len(errors) > 1:
        raise SyntaxError("DTML Tags are not allowed within PageContracts")

    e_handles = {}
    
    lines=split(errors[0],'\n')
    
    for line in lines:
        line = strip(line)
        if not line: continue
        try:
            var, e_handler = split(line, ':')
        except: #ugly
            if not e_handles.has_key('__default__') and count(line,':')<=1:
                e_handles['__default__'] = strip(line)
                continue
            else:
                if DEBUG: print "offending \n", line
                raise SyntaxError("Syntax Error in dtml-contract: \
                        exceptions section format is var_name:handler")

        e_handles[strip(var)]=strip(e_handler)
        
    if DEBUG: print "Error Handlers Found", e_handles
    
    return e_handles

def extract_filters(filterBlock):
                    # using this optimization prevents user registrations
                    # , filter_types=filter_keys,
                    # sort_filters=sort_filters):
    """
    Extracts per variable filters and filter arguements from
    the dtml-params section. the expected format is
    
    var_name:filter1, filter2(arg1 arg2), filter3
    
    Overall this is probably the weakest section of dtml-contract,
    if anyone wants to rewrite it, feel free. the expected output are
    two dictionaries corresponding to the filters and the filter args.
    All the processing here is soley string based. so a reference to a
    filter below is reference to the filter name not the function.
    
    some limitations on this current incarnation.
    1. syntax for filter_args is filter(arg1 arg2 arg3).
    2. because of the poor parsing routine here no spaces are allowed in args
    3. and no , are allowed except for separation of filters.
    4. and no : are allowed except for separation between var_name
    and filters
    
    @param filterBlock the enclosed <dtml-param> section
    @param filter_types a list of the current allowed filters
    @param sort_filters a function that sorts filters in execution order
    @return page_filters a dictionary of var_name->[filters]
    @return page_filter_args a dictionary of (var_name,filter)->(filter_args)
    @throws SyntaxError if not well-formed
    @throws FilterNotSupportedError if filter is not currently available
    """
    global filter_keys, sort_filters
    filter_types = filter_keys
    sort_filters = sort_filters
    
    if DEBUG: print 'Parsing Params'

    if len(filterBlock) > 1:
        raise SyntaxError("DTML Tags are not allowed within PageContracts")
    
    page_filters={}
    page_filter_args={}
    
    lines = split(filterBlock[0], '\n')
    
    for line in lines:
        line = strip(line)
        if not line: continue

        try:
            name, filters = split(line, ':')
        except:
            raise SyntaxError("""Syntax Error in dtml-contract 
            param section format = var_name:filter1, filter2(arg1 arg2)""")
    
        filter_list = filter(None, map(strip,split(filters, ',')))
        
        if DEBUG: print "Filter List", filter_list

        processed_filters = []
        
        for f in filter_list:
            if '(' in f: # check for args
                try:
                     si=index(f, '(')
                     ei=index(f, ')')
                     page_filter_args[(name,f[:si])]=tuple(
                             filter(None,split(f[si+1:ei],' ')))
                     f = f[:si]
                except:
                        raise SyntaxError("""Syntax Error in dtml-contract 
                        param section
                        format = var_name:filter1, filter2(arg1 arg2)""") 
                    
            if f not in filter_types:
                    raise FilterNotSupportedError("%s filter not supported"%f)
            else: 
                processed_filters.append(f)
            
        if DEBUG: filter_list, page_filter_args, processed_filters
        
        processed_filters.sort(sort_filters)
        page_filters[strip(name)]=processed_filters

    return page_filters, page_filter_args


def validate(p_filters, p_filter_args, namespace, strict=0):
        # , filters=filters):        
    """
    Applies a list of filters to variables in the Request, and returns
    a list of errors that occured during the application of filters.

    takes an optional parameter strict which deletes all variables in
    the Request which were not part of the specified contract varibles.

    filters are allowed to change the value of the request variable.

    @param p_filters a dictionary of var_name->[filters]
    @param p_filter_args a dictionary of (var_name,filter)->(filter_args)
    @param namespace the namespace MultiMapping
    @param strict an optional boolean switch
    @param filters a dictionary of filter functions -- see Filters.py
    @throws No exceptions (although a bad filter might throw something)
    @returns a list of errors that occured during validation
    """
    errors = []
    REQUEST = namespace['REQUEST']
    preproc = lambda x: hasattr(x, 'prefilter')
    global filters
    filters = filters # convert global to local

    #if DEBUG: print "Begin Validating"    

    for var in p_filters.keys():
        #if DEBUG: print "Validating", var
            
        if REQUEST.has_key(var)==0:
            if 'optional' in p_filters[var]:
                continue                
            errors.append((var,'%s is a required field'%var))
            continue
            
        for f in p_filters[var]:
            #if DEBUG: print 'validating ', f, type(f)
            #if DEBUG: print p_filter_args.get((var,f), ())
            
            errors.append(apply(filters[f][0],
                                (var, REQUEST[var],namespace)+p_filter_args.get((var,f),())
                                ))
             
    if strict: # remove vars not in params from request
        form_vars = REQUEST.form.keys()
        page_vars = p_filters.keys()
        
        for fvar in form_vars: 
            if not fvar in page_vars: del REQUEST.form[fvar]                

    #if DEBUG: print "Done Validating got back", errors
    
    return filter(None,errors)
