"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

"""
$Id: Filters.py,v 1.1.1.1 2001/12/31 04:07:06 ender Exp $
"""

import string
from string import strip
from string import strip, index, split
from DateTime import DateTime
import types

def TrimFilter(name, value, md):
    # may raise type error if used on int (ie with ZPublisher)

    if type(value) is type(''):
        value = strip(value)
    else:
        print name, value
        return (name, "Inputs to TrimFilter must be strings, %s"%name)    

    md['REQUEST'][name]=value
    return 

def FloatFilter(name, value, md):
    try:
        value=float(value)
        md['REQUEST'][name]=value
    except:
        return (name,"Value for %s required to be a float"%name)
    return

def DateFilter(name,value,md):
    try:
        value=DateTime(value)
        md['REQUEST'][name]=value
    except:
        return (name,"Value for %s required to be a Date"%name)

def NoHTMLFilter(name,value,md): 
    if string.find(value, '<') >= 0:
        return (name,"Value for %s contains illegal HTML"%name)

def NewObjectIdFilter(name,value,md,folder=None):
    """ pass in name of objectmanager, check to make sure value
    not an object id, this probably should mimic more precisely the
    behavior of objectmanager checking a new id, currently its more
    just a does not exist test """
    
    if folder: objectids = md[folder].objectIds()
    else: objectids = md['objectIds']; folder='This Folder'
    if value in objectids or value=='':
        return (name, "Value for %s must be unique id for %s"%(name,folder))
    return

    ### better for large folders?
    if hasattr(folder.aq_base,value):
        return (name, "Value for %s must be unique id for %s"%(name,folder))
    return
    
def ExistingObjectIdFilter(name,value,md,folder=None):
    """ pass in name of folder, check to make sure value is an object id"""
    
    if folder: folder = objectids = md[folder].objectIds()
    else: objectids = md['objectIds']; folder='This Folder'
    if value == '' or not value in objectids:
        return (name, "Value for %s must be an object id for %s"%(name,folder))
    return            

def NaturalNumFilter(name,value,md):
    """ requires number to have value greater than >0.
    implicit conversion of floats, etc """
    
    try:
        value = int(value)
        if value > 0:
            md['REQUEST'][name]=value
            return
    except: pass
    return (name,"Value for %s required to be a natural number")

def EmailFilter(name,value,md):
    """this filter needs lots of improvements"""
    if '@' in value and '.' in value and len(value)>7:
        return
    return (name,"Value for %s does not appear to be a valid email address"%name)


def RangeFilter(name, value, md, type, min, max):
    """ not currently callable by contract """
    
    if type not in ('int', 'float', 'DateTime'):
        return "Invalid type for Range Filter on %s"%s
    # faster but, security big security risk
    #map(eval,['%s(%s)'%(type,str(value),'%s(%s)'%(type,min),'%s(%s)%(type,max)]
    convert=eval(type)
    try:
        vals=map(convert,[value,min,max])
    except:
        return (name,"Min and Max to range must be of type %s"%type)
    if vals[0] > vals[1] and vals[0] < vals[2]:
        return
    
    return (name,"Value for %s required to be between %s and %s"%(name,min,max))

def IntegerFilter(name,value,md):
    try:
        value = int(value)
        md['REQUEST'][name]=value
    except:
        return (name,"Value for %s required to be an integer"%name)

def OptionalFilter(name, value, md): return

# Prefilter
OptionalFilter.prefilter = 1

filters= {'trim':(TrimFilter, 150, 'trim'),
            'float':(FloatFilter, 400, 'number'),
            'integer':(IntegerFilter, 200, 'number'),
            'naturalnum':(NaturalNumFilter,800, 'number'),
            'nohtml':(NoHTMLFilter, 2000, 'html'),
            'date':(DateFilter,1000, 'date'),
            'optional':(OptionalFilter,0, 'optional'),
            'range':(RangeFilter,2500,'number','date'),
            'newobid':(NewObjectIdFilter,5000,'objectid'),          
            'obid':(ExistingObjectIdFilter,4500,'objectid')
            }
filter_keys = filters.keys()

def sort_filters(x,y): 
    global filters
    if filters[x][1] > filters[y][1]:
        return 1
    else:
        return -1

def register_filter(name,info_tuple):

    global filters
    global filter_keys
    
    #if name in filter_keys:
    #raise "Filter Already Exists"
    if len(info_tuple) != 3:
        raise "Invalid Info Tuple : should be (Func, priority int, group)"
    elif type(info_tuple[0]) != types.FunctionType:
        raise "Invalid Info Tuple : should be (Func, priority int, group)"
    elif type(info_tuple[1]) != types.IntType:
        raise "Invalid Info Tuple : should be (Func, priority int, group)"
    elif type(info_tuple[2]) != types.StringType:   
        raise "Invalid Info Tuple : should be (Func, priority int, group)"
    else:
        filters[name]=info_tuple
        filter_keys = filters.keys()

                
        
        
    
