"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from OFS.ObjectManager import checkValidId, BadRequestException

def ValidIdFilter(name, value, md):
    """ not sure about how this is going to interact
    with the md, in dtml. in python products it works"""
    try:
        checkValidId(md,value)
    except BadRequestException, e:
        return "%s bad id "%(name) +str(e)

def PhoneFilter(name, value, md):
    """ basic phone number checking and formatting """

    if len(value) == 0:
        return
    value = value.replace('(', '')
    value = value.replace(')', '')
    value = value.replace('-', '')
    value = value.replace(' ', '')

    
    try:
        if value[0] == '1':  # trim country code
            value = value[1:]
    except:
        return (name,
                "Value for %s does not appear to be a valid US Phone Number"%name)        
    if not value.isdigit() or len(value) != 10:
        return (name,
                "Value for %s does not appear to be a valid US Phone Number"%name)
    
    areacode = value[0:3]
    prefix = value[3:-4]
    suffix = value[-4:]

    phone_number = "(%s) %s-%s"%(areacode, prefix, suffix)
    md['REQUEST'][name]=phone_number

def ValueConstraintFilter(name, value, md, value_list_name):
    """ makes sure that the variables is within a value list
    denoted by value_list_name which is acquired from context"""
    try:
        value_list = md[value_list_name]
    except: value_list = getattr(md,value_list_name)

    if type(value) == type(''):
        if value not in value_list:
            return (name, "Value for %s is not valid"%name)
    elif type(value) == type([]):
        # zope exhibits some wierd behavior in conj
        for v in value:
            if v not in value_list:
                return (name, "Value for %s is not valid"%name)
    else:
        if value not in value_list:
            return (name, "Value for %s is not valid"%name)            

def MaxSizeLimitFilter(name,value, md, limit):

    try:
        limit = int(limit)
    except:
         raise "Error in SizeLimitFilter please make sure limit arg an integer"
        
    if len(value) > limit:
        return (name, "Value for %s is too long"%name)
    

def MinSizeLimitFilter(name,value, md, limit):

    try:
        limit = int(limit)
    except:
         raise "Error in SizeLimitFilter please make sure limit arg an integer"
        
    if len(value) < limit:
        return (name, "Value for %s is too small"%name)    

def EmailFilter(name, value, md):
    """ barebones email validity check """
    if not len(value) > 6 or value.find('@')==-1 or value.find('.')==-1:
        return (name, "%s does not appear to be a valid email address"%value)

GreaterEqualZero = lambda x: x >= 0

def Email2UIDFilter(name, value, md):
    """ converts an email to a CTS uid, to be used in conjunction
    with an email filter"""
    
    value = value.replace('-','')
    aidx = value.find('@')
    didx = value.find('.')

    results=filter(GreaterEqualZero,(aidx,didx))
    if len(results) == 0:
        return
    elif len(results) == 1:
        results = results[0]
    else:
        results = min(results)

    md['REQUEST']['id']=value[:results]

def PasswordMatchFilter(name,value, md, password_confirm_name):
    """ checks that the password and password_confirm variables
    are the same """
    
    pwdc = md['REQUEST'][password_confirm_name]
    if not pwdc:
        return (name, "invalid passwords")
    try:
        
        if pwdc.strip() != value.strip() or not pwdc:
            return (name, "Passwords do not match")
    except:
        return (name, "Passwords do not match")

def NewUserIdFilter(name,value, md):
    """ makes sure that 'id' is a new userid """

    uf = md['acl_users']
    try:
        value = md['REQUEST'][name]
        user=uf.getUserById(value)
    except:
        return ('userid', ("we detected a problem with that user id"))
    
    if user:
        return ('userid', ("There is already a user with User Id %s"%value))


def DefaultFilter(name,value,md, type, default):
    """ bare bones default filter, sets a default regardless of value"""
    if type=='date':
        md['REQUEST'][name]=DateTime(default)
    
        

def FileFilter(name, value, md):
   """ super cheesy check that its file like for enough for reading """
   try:
       c = value.read
       d = value.readline
   except Exception, e:
       print str(e)
       return (name, "Value for %s does not appear to be a file"%name)        
   return 
        
from Filters import register_filter

register_filter('phone', (PhoneFilter, 1000, 'number'))
register_filter('constraint', (ValueConstraintFilter, 2000, 'value'))
register_filter('email', (EmailFilter, 1000, 'email'))
register_filter('email2uid', (Email2UIDFilter, 2000, 'objectid'))
register_filter('newuid', (NewUserIdFilter, 2000, 'userid'))
register_filter('pwd_confirm', (PasswordMatchFilter, 1000, 'password'))
register_filter('default', (DefaultFilter, 800, 'optional'))
register_filter('maxsize', (MaxSizeLimitFilter, 900, 'size'))
register_filter('minsize', (MinSizeLimitFilter, 1000, 'size'))
register_filter('file', (FileFilter, 900, 'file'))
register_filter('validid', (ValidIdFilter, 600, 'objectid'))


