"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

"""
$Id: PageContractTag.py,v 1.1.1.1 2001/12/31 04:07:06 ender Exp $

"""
# Zope Jaunx
from DocumentTemplate.DT_Util import *
from DocumentTemplate.DT_String import String
from DocumentTemplate.DT_Return import DTReturn
from DocumentTemplate import HTML


from Util import error_page
from CoreFuncs import extract_contract, extract_errors, extract_filters, validate


DEBUG=0

class PageContractTag:
    """
    More Documentation Can Be Had in the /doc directory of PageContract
    
    <dtml-contract>
    Documentation Here
    
    @author Kapil Thangavelu (k_vertigo@yahoo.com)
    @param recipe_id the name of the user
    @param foo catch me if you can
    <dtml-params>
    recipe_id:integer
    foobar:notnull,optional
    <dtml-exceptions>
    recipe_id:index_html
    </dtml-contract>
    """
    
    name = 'contract'
    blockContinuations = 'params','exceptions'
    paramsBlock=None


    def __init__(self, blocks):
        """
        initialization of the contract tag. initilization takes place
        when an object is changed or when an object is loaded from
        the zodb.

        initilization consists of the following

        1. parsing dtml-contract options
        2. parsing the base tag (documentation section)        
        3. parsing the continuations (params, exceptions) if present
        4. param parsing extracts variable names and associated filters.
        5. exception parsing extracts variable names and associated error
           handlers

        @param blocks the enclosed text of the contract tag
        @exceptions None
        """
        
        tagname, args, section = blocks[0]
                
        args = parse_params(args,
                            strict=None,
                            parse_doc=None,
                            redirect=None)


        if DEBUG: print "Beggining Page Contract Init"
        if DEBUG: print "Args",args 

        # contract doc extraction
        if args.has_key('parse_doc'):
            extract_contract(section)

        # strict handling of request vars
        if args.has_key('strict'):
            self.strict = 1
        else: self.strict = 0

        # determines if we redirect or write in place
        if args.has_key('redirect'):
            self.redirect = 1
        else: self.redirect = 0
            
        # parameter handling
        if len(blocks) >= 2 and blocks[1][0] == 'params':
            paramBlock = blocks[1][2].blocks
            self.filters, self.filter_args=extract_filters(blocks[1][2].blocks)
        else:
            raise "Need 'params' section in dtml-contract"
        
        # exception handling
        if len(blocks)==3 and blocks[2][0] =='exceptions':
            self.e_handlers=extract_errors(blocks[2][2].blocks)
        else: self.e_handlers = {}
        
        if DEBUG: print "Done Page Contract Init"
    
    def render(self, namespace):
        """
        renders the dtml-contract tag. dtml-contract does not render in
        the traditional sense of inserting text in a document. instead 
        it searches the namespace for the request object and calls
        filters on variables specified in the contract. however a filter
        has full access to the namespace and can do whatever it wishes.
        if errors occur during the application of filters than a error_handler
        is sought that matches the variable name, if none is found than
        a default one is used.

        if an error occurs and an error handler is found, the default
        behavior is to evalutate the error_handler in the current namespace
        with the variable contract_errors set to the errors from validation
        and to write the resultant string directly to the connection. a
        redirect flag can be passed but no information is sent with the
        redirect.
     
        @param namespace a MultiDictionary corresponding to the namespace
        of page evalutation
        @throws No exceptions
        """
        #if DEBUG: print "Doing Validation"
        
        errors = validate(self.filters, self.filter_args,
                          namespace, self.strict)
        
        #if DEBUG: print "Errors from validation", errors
        
        if errors:                                        
            handler = self.e_handlers.get(errors[0][0], None)                
            h=''
            
            if handler:
                if self.redirect:
                    namespace['RESPONSE'].redirect(handler)
                else:
                    h=namespace.getitem(handler)
                    
            elif self.e_handlers.has_key('__default__'):
                if self.redirect:
                    namespace['RESPONSE'].redirect(
                        self.e_handlers['__default__'])
                else:
                    h=namespace.getitem(self.e_handlers['__default__'])
            else:
                h = HTML(error_page)

            if h:
                    namespace['RESPONSE'].setHeader('Content-Type','text/html')
                    namespace['REQUEST']['contract_errors']=errors
                    namespace['RESPONSE'].write(
                        h(None,namespace,contract_errors=errors))
                    namespace['RESPONSE'].close()
            
            #get_transaction().abort()
            #raise SyntaxError("Page Contract Error")
            #raise TypeError("Page Contract Error")
            raise DTReturn('')
    
        
    __call__=render

String.commands['contract']=PageContractTag


