"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

# Wrappers to Expose contract Functionality
# in python

from Acquisition import Implicit
from Util import error_page
from DocumentTemplate import HTML

class NameSpaceAcqWrap(Implicit):

    def __getitem__(self, key):
        return getattr(self,key)


def handle_errors(errors, namespace):
    
    h = HTML(error_page)
    
    req = namespace['REQUEST']
    res = req.RESPONSE
    
    res.setHeader('Content-Type','text/html')
    req['contract_errors']=errors
    res.write(
        h(None,namespace,contract_errors=errors))
    
    res.close()
