"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

from UserDict import UserDict

from AccessControl import ModuleSecurityInfo, ClassSecurityInfo
from Products.PythonScripts.Utility import allow_module
from Globals import InitializeClass
from Acquisition import Implicit, aq_parent

from DocumentTemplate.DT_Util import *
from DocumentTemplate.DT_String import String
from DocumentTemplate.DT_Return import DTReturn
from DocumentTemplate import HTML
from Util import error_page

import Filters       

import CoreFuncs

allow_module('Products.PageContract.Scripts')

modulesecurity = ModuleSecurityInfo()
modulesecurity.declarePublic('compile')

class NameSpaceAcqWrap(Implicit): 
    
    def __getitem__(self, key):
        return getattr(self, key)

class VariableNamespace(UserDict):

    def __getattr__(self, name):
        return self.get(name)
    
    def as_dict(self):
        return self.data

class ContractObject(Implicit): 
    
    security = ClassSecurityInfo()
    security.declareObjectPublic()
    security.setDefaultAccess(1)
    
    def __init__(self, filters, errors):
        self.filters = filters
        self.e_handlers  = errors
    
    def extract_variables(self, REQUEST):
        res = {}
        var_names = self.filters[0].keys()
        
        for k in var_names:
            if k is type(()): continue
            if REQUEST.has_key(k):
                res[k] = REQUEST[k]
        return VariableNamespace(res)
        
    def validate(self, context, strict=0, no_error_handling=0, redirect=0):
        
        """ 
        @context ... not sure about if we get the multi mapping
        @strict
        @no_error_handling
        """
        found = 0
        ## ugh backwards compat bites
        if aq_parent(self) is not self:
            #print 'wrapping context'
 	    try: 
		self.REQUEST
                context = NameSpaceAcqWrap().__of__(self)
	        found = 1
 	    except: pass

        if not found:
            try: 
                r = context['REQUEST'] 
		found = 1
            except: 
                context = NameSpaceAcqWrap().__of__(context)

	if not found: print 'suspect'

        errors = CoreFuncs.validate(self.filters[0], self.filters[1], context, strict)
        
        if no_error_handling: return errors
        
        if errors:  ## FIX ME                                       
            handler = self.e_handlers.get(errors[0][0], None)                
            h=''
            
            if handler:
                #print 'got handler'
                #print handler                
                if self.redirect:
                    context['RESPONSE'].redirect(handler)
                else:
                    h=context.getitem(handler)
                    
            elif self.e_handlers.has_key('__default__'):
                #print 'got default in contract'
                if redirect:
                    context['RESPONSE'].redirect(
                        self.e_handlers['__default__'])
                else:
                    h=context[self.e_handlers['__default__']]
            else:
                #print 'print default'
                h = HTML(error_page)
                print h(self, context.REQUEST, contract_errors = [])

            if h:
                #print 'errors', errors
                context['REQUEST'].RESPONSE.setHeader('Content-Type','text/html')
                context['REQUEST'].RESPONSE.write(
                                                  h(self,
                                                    context.REQUEST,
                                                    contract_errors=errors)
                                                  )
                context['RESPONSE'].close()

            # i'm a little unsure about the best overall error
            # handling policy...
            get_transaction().abort()            
            raise TypeError("you can't see the gingerbread man")
        
                 
InitializeClass(ContractObject)    
    
def compile(contract_source, object=None, cache=0):
    """ 
    parse a contract and return a contract object
    
    caveats: the parsing is fairly simple, patches welcome ;)
     
    @contract is the string definition of a contract
    @object is the object that is compiling this contract
            the returned contract is wrapped with this ob as context...
    @cache states whether to cache the compiled contract
           on the calling object (if object is given)
    
    """    
    
    if object is not None and hasattr(object, '_v_contractcache'): 
        print 'getting obj from cache'
        cobj = object._v_contractcache.get(hash(contract_source), None)
        if cobj is not None: return cobj
        
    sections = ('#parameters', '#errors')
    
    contract = contract_source.strip()

    contract_lines = contract.split('\n')
    
    cur = None
    cur_section = ()
    res = {}
    
    for l in contract_lines: 
        #print l
        l = l.strip()

        if not l: continue
        
        if l in sections:

            if cur is not None:
                res[cur[1:]]='\n'.join(cur_section)
            cur = l
            cur_section = []                
            
        elif cur:
             cur_section.append(l)
         
        else: raise "Invalid Contract"        
        
    res[cur[1:]]='\n'.join(cur_section)
        
    if not len(res) >= 1 and len(res) < 3:
           raise SyntaxError("Invalid Contract Syntax 3")

    try:
        filters = CoreFuncs.extract_filters([res['parameters']])
        if res.has_key('errors'):
            errors = CoreFuncs.extract_errors([res['errors']])
        else: errors = {}
    except Exception, e: 
        import sys
        print 'page contract error', e
        raise SyntaxError('Invalid Contract Syntax during Extraction')

    cobj = ContractObject(filters, errors)

    ## need to unwrap obj
    
    if cache and object is not None:
        store = getattr(object, '_v_contractcache', None)
        if store: store[hash(contract_source)]=cobj
        else: object._v_contractcache = {hash(contract_source):cobj}
        
    if object: cobj = cobj.__of__(object)
    return cobj
    
    
modulesecurity.apply(globals())    


