import unittest
import os
import sys

sys.path.append(os.path.abspath(os.pardir))

from core_funcs_tests import ErrorExtractionTests, FilterExtractionTests, ValidationTests


def make_core_suite():
    csuite = unittest.TestSuite()
    csuite.addTest(make_error_extraction_suite())
    csuite.addTest(make_filter_extraction_suite())
    csuite.addTest(make_validation_suite())

    return csuite

def make_validation_suite():
    vsuite = unittest.TestSuite()
    vsuite.addTest(ValidationTests("testCanonicalCase"))
    vsuite.addTest(ValidationTests("testOptionalFilterCase"))
    vsuite.addTest(ValidationTests("testFiltersWithArgsCase"))
    vsuite.addTest(ValidationTests("testStrictCase"))
    vsuite.addTest(ValidationTests("testErrorMessageCase"))    

    return vsuite

def make_filter_extraction_suite():
    
    fsuite = unittest.TestSuite()
    fsuite.addTest(FilterExtractionTests("testCanonicalCase"))
    fsuite.addTest(FilterExtractionTests("testSpacesCase"))
    fsuite.addTest(FilterExtractionTests("testFiltersWithArgsCanonicalCase"))
    fsuite.addTest(FilterExtractionTests("testFiltersWithArgsAndSpacesCase"))
    fsuite.addTest(FilterExtractionTests("testFiltersWithArgsAndCommasCase"))
    
    return fsuite

def make_error_extraction_suite():
    esuite = unittest.TestSuite()
    esuite.addTest(ErrorExtractionTests("testCanonicalCase"))
    esuite.addTest(ErrorExtractionTests("testSpacesCase"))
    esuite.addTest(ErrorExtractionTests("testErrorHandlerWithSpacesCase"))
    esuite.addTest(ErrorExtractionTests("testMultipleColonsCase"))
    esuite.addTest(ErrorExtractionTests("testDefaultHandlerCase"))
    esuite.addTest(ErrorExtractionTests("testMultipleDefaultHandlerCase"))    

    return esuite


if __name__ == '__main__':
    runner = unittest.TextTestRunner()
    runner.run(make_core_suite())

