"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: $

import xmlrpclib

repository_xrpc_url = 'http://epox:40080/test2/Services/xmlrpc'

def search_packages(query):
    server =  xmlrpclib.Server( repository_xrpc_url )
    return server.search_packages(query)

def get_package_info(pkgid):
    server = xmlrpclib.Server( repository_xrpc_url )
    return server.get_package_info(pkgid)

def get_author_info(authorid):
    server = xmlrpclib.Server( repository_xrpc_url )
    return server.get_author_info(authorid)

if __name__ == '__main__':
    
    print 'searching for xml packages'
    print search_packages('xml')
    
    print
    print
    
    print 'searching for author Fourthought'
    print get_author_info('FourThought')
    
    print
    print
    
    print 'searching for package info ciphon'
    print get_package_info('ciphon')
    
