"""
 (C) Copyright 2002 Kapil Thangavelu <kvthan@wm.edu>
 All Rights Reserved

 This file is part of Gideon.

 Gideon is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 Gideon is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with Gideon; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"""

# $Id: Ratings.py,v 1.2 2002/02/23 01:37:57 ender Exp $

"""
  Ratings.py
  
  Simple and efficient object rating system

  requirements

    scalable

	allow numeric ratings, once per authenticated user.

	should support future data mining ie.

	  - data analysis of ratings to provide users with
	    packages they will probably like.

	A brief chat on irc revealed two distinct approaches.             

	A rating storage container with ratings stored in a
	OIbtree with indexes of object physical path and userid.

	or a hashed user index to numeric value store in a IIBTree
	with the rating object stored local to the rated object.
	 
  Author: Kapil Thangavelu <kvthan@wm.edu>
  Copyright: @2001 kapil thangavelu
  LICENSE: GPL

"""

from BTrees.IIBTree import IIBTree
from BTrees.Length import Length
from OFS.SimpleItem import SimpleItem
from Acquisition import Implicit
from AccessControl import getSecurityManager, ClassSecurityInfo
from ZTUtils.Zope import make_query
from Globals import  InitializeClass, DTMLFile

manage_addRatingsForm = None

def manage_addRatings(self,
					  id='Ratings',
					  REQUEST=None
					):
	self.id = id
	if REQUEST is not None:
		REQUEST.RESPONSE.redirect('manage_main')


class Rating(SimpleItem, Implicit):

	id = 'Ratings'
	
	security = ClassSecurityInfo()

	security.declarePublic('__call__')# logical
	__call__ = DTMLFile('ui/RatingView', globals())
	
	index_html = None

	security.declarePublic('thank_you')
	thank_you  = DTMLFile('ui/RatingThankYou', globals())

	security.declarePublic('already_voted')
	already_voted = DTMLFile('ui/RatingAlreadyVoted', globals())
	
	_scale = 6 # means we allow votes from 1 to scale

	def __init__(self, id='Ratings'):
		self.id = 'Ratings'
		self._data = IIBTree()
		self._num_votes = Length(0)
		self._vote_sum = Length(0)

	security.declarePublic('add_rating')
	def add_rating(self, value=None, REQUEST=None):
		""" """
		try: value = int(value)
		except: return 
		
		if value not in range(1, self._scale,1): return

		uname = getSecurityManager().getUser().getUserName()
		
		if uname == 'Anonymous User' and REQUEST is not None: 
			# should redirect with form stuff in tact
			return_url = ''.join([self.get_login_url(),
						'?',make_query(value=value,
				return_url=self.absolute_url()+'/add_rating',)
					])
			
			REQUEST.RESPONSE.redirect(return_url)

		if self._data.has_key(hash(uname)):
			return self.already_voted(self)
				
		self._data[hash(uname)]=int(value)
		self._num_votes.change(1)
		self._vote_sum.change(value)

		if REQUEST is not None:
			REQUEST.RESPONSE.redirect(self.aq_parent.absolute_url())

	security.declarePublic('get_number_votes')
	def get_number_votes(self):
		""" """
		return self._num_votes()
			
	security.declarePublic('get_average_rating')
	def get_average_rating(self):
		""" return rating as string formated float """
		if self._num_votes():
			return 	"%1.1f"%(self._vote_sum() / float(self._num_votes()))
		else: return 'N/A'

	security.declarePrivate('get_numeric_rating')
	def get_numeric_rating(self):
		""" """
		return self._vote_sum()/float(self._num_votes())

	security.declarePublic('get_vote_url')
	def get_vote_url(self):
		return self.absolute_url()+'/add_rating'
	
InitializeClass(Rating)
