# Author: Kapil Thangavelu <kvthan@wm.edu>
# CVS: $Id: ThreadSpecificStorage.py,v 1.1.1.1 2001/09/28 06:10:43 ender Exp $


from Storage import _storage, _create_tss
import whrandom

try:
    from thread import get_ident
    from threading import Lock
    l = Lock()
    _a = l.acquire
    _r = l.release
except:
    # print warning?
    def _a(): pass
    def _r(): pass
    def get_ident(): return 1
    
    
def storage_id_generator(randint=whrandom.randint,
                         choice=whrandom.choice,
                         signs=(-1,1)):
    return choice(signs)*randint(1,2000000000)
 
class ThreadSpecificStorage:

    def __init__(self):
        """
        a TLS storage accessor
        """
        try:
            _a()            
            id = storage_id_generator()
            while not _create_tss(id):
                id = storage_id_generator()
            self.id = id
        finally:
            _r()
        
    def get(self,default=None,func=get_ident):

        return _storage.get(func(),default)

    def set(self, obj, func=get_ident):

        _storage[func()]=obj

    


