from Acquisition import Implicit
from Globals import Persistent
from AccessControl.Role import RoleManager
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass
from Globals import DTMLFile, HTMLFile
from Globals import MessageDialog
from DocumentTemplate.DT_Util import html_quote
import time
import re
import string 
import urllib 
import httplib 
import urlparse
import traceback, sys, os 
from OFS.SimpleItem import Item

addForm = DTMLFile('dtml/addForm',globals())

def manage_addKebasData(self, id, url, regex_pattern, title='',start_kebas='', end_kebas='', render_method='', request_method='GET',params='', REQUEST=None):
	"""the add method"""
	ob = KebasData(id, url, regex_pattern, title, start_kebas, end_kebas, render_method,request_method,params)
	self._setObject(id,ob)
	if REQUEST is not None:
		return REQUEST.RESPONSE.redirect('manage_workspace') 

class KebasData(Implicit, Persistent, RoleManager, Item):
	"""my first attempt to a python product."""
	##new attribs 
	title=''
	request_method = 'GET'
	params = []
	

	meta_type = 'Kebas Data'

	manage_options=(
              {'label' : 'Edit', 'action' : 'editKebasDataForm', 'help': ('KebasData','edit.txt')},
              {'label' : 'View', 'action' : '', 'help': ('KebasData','index.txt')},
              {'label': 'Properties' , 'action':'main'},
              {'label': 'Test' , 'action':'test'},
		) + RoleManager.manage_options + Item.manage_options

	security=ClassSecurityInfo()
	main= DTMLFile('dtml/main',globals())
	test= DTMLFile('dtml/test',globals())
	security.declareProtected('View management screens','editKebasDataForm')
	editKebasDataForm = DTMLFile('dtml/editKebasDataForm',globals())
	index_html = HTMLFile('index_html',globals())

	def __init__(self, id, url, regex_pattern, title='',start_kebas='', end_kebas='', render_method='',request_method='GET',params=''):
		"""my init"""
		self.id = id
		self.title = title
		self.url = url
		self.regex_pattern = regex_pattern
		self.start_kebas = start_kebas
		self.end_kebas = end_kebas
		self.match=[]
		self.render_method = render_method
		self.refresh_time = 3600
		self.last_refresh = time.time()
		self.request_method = request_method
		#print params, 'my params'
		if params[0] == 0:
			self.params = []
		else:
			self.params =params

	def _get_url(self,url, REQUEST=None):
		"""get the url"""
		#print self.url
		self.url = url
		self.start_kebas_re = re.compile(self.start_kebas, re.I|re.S|re.DOTALL)
		self.end_kebas_re = re.compile(self.end_kebas, re.I|re.S|re.DOTALL)

		if self.request_method == 'GET':
			self._get_method()
		else:
			self._post_method()

		#print 'got here too'
		if len(self.f) != 0:
			if self.start_kebas == '' and self.end_kebas == '':
				self.f = self.f
			else:
				x = self.start_kebas_re.search(self.f)
				y = self.end_kebas_re.search(self.f)
				try:
					self.f = self.f[x.end():y.start()]
				except:
					tb = traceback.extract_tb(sys.exc_info()[2])
                			tb.reverse()
                			self._v_errors = ["failed",
                                  	"%s: %s" % sys.exc_info()[:2],
                                  	] + map(str, tb)
		return self.f

		if REQUEST is not None:
			return self.editKebasDataForm(REQUEST,
                      management_view='Edit',
                      manage_tabs_message='Kebas Data attributes changed.')

	def _get_method(self):
		"""get method used"""
		try:
			self.f = urllib.urlopen(self.url).read()
		except:
			self.f = []
		
	def _post_method(self):
		"""post method used"""
		url_split = urlparse.urlparse(self.url)
		myhost = url_split[1]
		myscript = url_split[2]
		key_value = {}
		#print len(self.params), len(self.params) % 2
		#any sense in getting key value pairs from the url itself?  any use?
		if (len(self.params) != 0 and len(self.params) % 2 == 0) or url_split[4]:
			if url_split[4]:
				for i in string.split(url_split[4],'&'):
					k,v=string.split(i,'=')
					key_value[k]=v
				key_value = urllib.urlencode(key_value)
			else:
				for i in range(0,len(self.params),2):
					key_value[self.params[i]] = self.params[i+1]
				key_value = urllib.urlencode(key_value)
		
		#commented.  meant as the above
		#if len(self.params) != 0 and len(self.params) % 2 == 0:
		#	for i in range(0,len(self.params),2):
		#		key_value[self.params[i]] = self.params[i+1]
		#	key_value = urllib.urlencode(key_value)
		
			try:
			# should try usng urllib here.  urllib.urlopen(self.url,key_value).read()
				h=httplib.HTTP(myhost)
				h.putrequest('POST',myscript)
				h.putheader('content-Length','%d' % len(key_value))
				h.putheader('Accept','text/plain')
				h.endheaders()
				h.send(key_value)
				reply, msg, hdrs = h.getreply() 
				self.f = h.getfile().read()
			
			except: pass
		else:
			self.f = []

	security.declarePublic('index_html')
	def index_html(self,REQUEST=None):
		"""default view"""
		head = "<html><body>"
		foot = "</body></html>"
		return head + self.view() + foot

	security.declareProtected('Access Kebas Data get_matched','get_matched')
	def get_matched(self, url=None, REQUEST=None):
		"""get the matched pattern"""
		if url is not None:
			self.url = url
			self.f = self._get_url(url=self.url)
		else:
			self.f = self._get_url(url=self.url)
		self.regex = re.compile(self.regex_pattern,re.I|re.S)
		self.match = []
		if len(self.f) != 0:
			self.match= self.regex.findall(self.f)
			#print self.f, self.match, 'in getmatch'
			self._p_changed = 1
			self.last_refresh = time.time()
			#return self.match
			if not self.match:
				return self.editKebasDataForm(REQUEST,
                      			management_view='Edit',
                      			manage_tabs_message='<span style="color: red;"><strong>Kebas Data not initialized.  \
		      			No match found. \
		      			Check your regex pattern and URL</strong></span>')
			else:
				if REQUEST is not None:
					return self.editKebasDataForm(REQUEST,
                      			management_view='Edit',
                      			manage_tabs_message='Kebas Data initialized.')
				else:
					return """ done self.index_html(REQUEST)"""
		else:
			 return self.editKebasDataForm(REQUEST,
                                        management_view='Edit',
                                        manage_tabs_message='<span style="color: red;"><strong>Kebas Data not initialized.  \
                                        Check that your Parameter list have all key:value pairs, \
					Check your regex pattern and URL.</strong></span>')


	security.declareProtected('View management screens','test_file')
	def test_file(self,REQUEST=None):
		"""for better debugging, show data from what we grabbed"""
		return self.test(REQUEST,
		                   management_view='Test',
				   manage_tabs_message='Kebas Data returned data.')

	security.declareProtected('View management screens','reset')
	def reset(self,REQUEST=None):
		"""resets re objects in Kebas Data instance"""
		self.regex = ''
		self.end_kebas_re = self.start_kebas_re = ''
		if REQUEST is not None:
		return self.editKebasDataForm(REQUEST,
		management_view='Edit',
		manage_tabs_message='Kebas Data re objects reset.')

	security.declarePublic('view')
	def view(self,REQUEST=None):
		"""Custom view.  calls dtml method defined in render_method.  this is currently a hack,
		until i get the equivalent to what i'm doing here.
		What i'm doing here is - set up a file called custom_view.dtml, and has 
		<dtml-var "_[render_method]">.  any elegant way of acieving this in python?

		with TheJester's help, i have that elusive solution.
		<TheJester> calls it has a function
		<TheJester> and passes self and REQUEST through
		<TheJester> self basically gives you acquisition
		<TheJester> REQUEST gives you REQUEST
		<TheJester> d;)
		<kedai> getattr gets the the attribute if its there, and (self,REQUEST) calls it?
		<TheJester> yes
		<TheJester> you could do this...
		<TheJester> imageMethod=getattr(self, x)
		<TheJester> imageMethod(self, REQUEST)
		<TheJester> you wanna know something even sicker...
		<TheJester> imageMethod=getattr(self, x)(self, REQUEST)[5:]
		<TheJester> or even
		<TheJester> imageMethod=getattr(self, x)(self, REQUEST)['lines'][1]
		"""
		t=self._chk_time()
		if t == 1:
			self.get_matched()
		if self.render_method != '':
			try:
				return getattr(self,self.render_method)(self,REQUEST)
			except:
				return self.main(REQUEST,
                      			management_view='View',
                      			manage_tabs_message='<span style="color: red;">\
					<strong>render_method defined, but no rendor_method <i>%s</i>\
                      			found</strong></span> %s' \
					 % (self.render_method,Item.raise_standardErrorMessage(self)) )
		else:
			return self.main(REQUEST)

	def _chk_time(self):
		"""Check for freshness according to user request"""
		if not hasattr(self,'last_refresh'):
                	self.last_refresh=time.time()
		if not hasattr(self,'refresh'):
			self.refresh = 3600
		self.do_refresh = 0
		delta_t = time.time() - self.last_refresh
		if delta_t > int(self.refresh):
			self.do_refresh = 1
		return self.do_refresh

	security.declareProtected('Change Kebas Data','manage_editKebasData')
	def manage_editKebasData(self, title, url, regex_pattern, start_kebas='', end_kebas='', render_method='',
		refresh='', request_method='GET', params ='',  REQUEST=None):
		"""change method"""
		self.url = url
		self.title = title
                self.regex_pattern = regex_pattern
		self.start_kebas = start_kebas
		self.end_kebas = end_kebas
                self.match=[]
		self.render_method = render_method
		#print params,'b4 change'
		if params[0] == '':
			self.params = []
		else:
			self.params = params
		#print self.params
		if refresh == '':
			self.refresh=3600
		else:
			self.refresh=refresh
		self.request_method = request_method
		if REQUEST is not None:
			return self.editKebasDataForm(REQUEST,
				management_view='Edit',
				manage_tabs_message = 'Attributes changed')

InitializeClass(KebasData)
