# utility method
def getfqdn():
    import string, socket
    hostname, aliaslist, ipaddrlist=socket.gethostbyaddr(socket.gethostname())
    name = hostname
    for alias in aliaslist:
        if string.find(alias, '.') > -1:
            name = alias
    return name

##############################################################################
#
# Product to restart the Zope server when:
#
# - the asyncore socket_map size meets or exceeds a user-defined maximum
#   size (MAP_SIZE_LIMIT) and, at the same time, the select loop time out.
#   This situation indicates a deadlock, perhaps caused by irreconcilable
#   database connection consumption or leakage.
#
# OR
#
# - the process memory size in bytes exceeds the value of the ZOPE_MEMLIMIT
#   variable.  Limiting the memory size can prevent swapping or other
#   undesirable behavior.  When ZOPE_MEMLIMIT envvar is set to 0, this limit
#   is not enforced.  The ZOPE_MEMLIMIT_CHECK_EVERY variable can also be set to
#   specify how many seconds to wait between each memory limit check.
#   This feature only works on Linux platforms currently.
#
# The SLEEP_BEFORE_RESTART specifies  the number of seconds to wait before
# restarting the server after the pathological situation is detected.
#
# The product also logs a message to the Zope event log before a restart
# occurs. If EMAIL_FROM, EMAIL_TO and SMTP_SERVER variables are specified in
# the configuration, the products send an email message noting the event.
#
# To use this product:
#
# - Install the product in your Products directory
#
# - Edit the customizable elements below such as MAP_SIZE_LIMIT, EMAIL_TO,
#   etc.
#
# - Restart your Zope process
#
# Note that this product only does its full job on systems which provide
# "daemon" services to Zope.  Most notably this does not inlcude Zope run
# from a Windows command line, but does include Zope run as a Windows service.
##############################################################################

##############################################################################
# AutoLance configuration
#
# change the following parameters as necessary
#
# maximum process memory size in kilobytes.
# default is 400MB.
#
ZOPE_MEMLIMIT = 400000
#
# check every n seconds for process size
# default is 300 (5 minutes)
#
ZOPE_MEMLIMIT_CHECK_EVERY = 300
#
# max number of connections when a select timeout occurs (0 is infinite)
# default is 150
#
MAP_SIZE_LIMIT = 150
#
# "to" address for restart email (blank string or None to send no email)
# default is blank
# 
EMAIL_TO = ''
#
# "from" address for restart email
# default is zope@<fqdn>
#
EMAIL_FROM = 'zope@%s' % getfqdn()
#
# stmp server to use for restart email
# default is 'localhost'
#
SMTP_SERVER = 'localhost'
#
# number of seconds to sleep before a system restart (perhaps giving Apache
# processes time to clear out)
# default is 30
#
SLEEP_BEFORE_RESTART = 0
#
#############################################################################

##############################
# NO EDITABLE ELEMENTS BELOW #
##############################

# hush up stupid syntax warnings under 2.X
socket_map = None

def patch_asyncore():
    import zLOG
    if MAP_SIZE_LIMIT:
        zLOG.LOG('AutoLance', zLOG.INFO, 'Deadlock detector mapsize limit set '
                 'to %s' % MAP_SIZE_LIMIT)
    global poll
    def poll (timeout=0.0, map=None):
        global DEBUG, socket_map
        if map is None:
            map = socket_map

        if map:
            r = []; w = []; e = []
            for fd, obj in map.items():
                if obj.readable():
                    r.append (fd)
                if obj.writable():
                    w.append (fd)
            r,w,e = select.select (r,w,e, timeout)
            map_sz = len(map)
            if DEBUG:
                print r, w, e, map_sz

            need_restart = 0

            if MAP_SIZE_LIMIT and ZDAEMON_MANAGED and map_sz > MAP_SIZE_LIMIT:
                if (not r) and (not w) and (not e):
                    # we are in a deadlock condition due to the fact a socket
                    # isnt readable or writable (indicated by a select timeout)
                    # even though we've got a socket map of an improbably
                    # large size.
                    need_restart = 1

            if need_restart:
                id = os.environ.get(
                    'ZEO_CLIENT',
                    socket.gethostbyaddr(socket.gethostname())[0])
                args=(id, map_sz, MAP_SIZE_LIMIT, timeout,SLEEP_BEFORE_RESTART)
                msg = (
                    "Restarting %s after deadlock detected by AutoLance "
                    "deadlock detector (%s pending conn exceeds limit of %s, "
                    "timeout %s, waiting for %s seconds before restart)." %args
                    )
                def shutdatabases():
                    import Globals
                    for db in Globals.opened:
                        db.close()
                import ZServer
                ZServer.clean_shutdown(
                            restart=1,
                            callback=shutdatabases,
                            msg=msg,
                            subj='Zope restarting',
                            mailto=EMAIL_TO,
                            mailfrom=EMAIL_FROM,
                            smtpserver=SMTP_SERVER,
                            sleep=SLEEP_BEFORE_RESTART
                            )
                
            for fd in r:
                try:
                    obj = map[fd]
                    try:
                        obj.handle_read_event()
                    except ExitNow:
                        raise ExitNow
                    except:
                        obj.handle_error()
                except KeyError:
                    pass

            for fd in w:
                try:
                    obj = map[fd]
                    try:
                        obj.handle_write_event()
                    except ExitNow:
                        raise ExitNow
                    except:
                        obj.handle_error()
                except KeyError:
                    pass

def patch_zserver():
    def clean_shutdown(restart=0, callback=None, msg='', subj='',
                       mailto='', mailfrom='', smtpserver='',
                       sleep=0, severity=300):
        import sys, asyncore, zLOG, socket, os, time
        import DebugLogger
        from PubCore.ZEvent import Wakeup
        sys.ZServerExitCode = 1
        try:
            Wakeup(lambda asyncore=asyncore: asyncore.close_all())
        except:
            zLOG.LOG('Zope shutdown', zLOG.PROBLEM,
                     'asyncore close_all() function failed', '',
                     sys.exc_info())            
        try:
            if callback: callback()
        except:
            zLOG.LOG('Zope shutdown', zLOG.PROBLEM, 'Could not call callback',
                     sys.exc_info())
        zLOG.LOG('ZServer clean_shutdown', severity, msg)
        DebugLogger.log('R', '000000000', 'ZServer clean_shutdown')
        if mailto and mailfrom and smtpserver:
            import smtplib
            try:
                server = smtplib.SMTP(smtpserver)
                body = "Subject: %s\n\n%s" % (subj, msg)
                server.sendmail(mailto, mailfrom, body)
                server.quit()
            except:
                zLOG.LOG('Zope shutdown', zLOG.PROBLEM,
                         'Could not send  mail',
                         '', sys.exc_info())
        time.sleep(sleep)
        if restart:
            sys.exit(1)
        else:
            sys.exit(0)

    import ZServer
    ZServer.clean_shutdown = clean_shutdown

import sys, asyncore, time
asyncore.MAP_SIZE_LIMIT = MAP_SIZE_LIMIT
asyncore.ZDAEMON_MANAGED = hasattr(sys, 'ZMANAGED')
asyncore.EMAIL_TO = EMAIL_TO
asyncore.EMAIL_FROM = EMAIL_FROM
asyncore.SMTP_SERVER = SMTP_SERVER
asyncore.SLEEP_BEFORE_RESTART = SLEEP_BEFORE_RESTART
asyncore.DEBUG = 0
exec patch_asyncore.func_code in asyncore.__dict__

import os, string
ZSERVER_HOME = string.join(string.split(SOFTWARE_HOME, os.sep)[:-2], os.sep)
sys.path.append(ZSERVER_HOME)
import ZServer
exec patch_zserver.func_code in ZServer.__dict__
assert ZServer.__dict__.has_key('clean_shutdown')

if ZOPE_MEMLIMIT and ZOPE_MEMLIMIT_CHECK_EVERY:
    # fire off checker thread
    import threading
    class AutoLanceMemChecker(threading.Thread):
        def __init__(self, size, every, mailto, mailfrom, smtpserver, sleep):
            self.size = size
            self.every = every
            self.mailto = mailto
            self.mailfrom = mailfrom
            self.smtpserver = smtpserver
            self.sleep = sleep or 0
            threading.Thread.__init__(self)
            self.setName('AutoLance MemChecker thread')
            self.setDaemon(1) # dont hold up a shutdown
 
        def run(self):
            import zLOG, sys
            if sys.platform not in ['linux2', 'linux-i386']:
                zLOG.LOG('AutoLance', zLOG.PROBLEM,
                         'MemChecker unable to run on non-Linux platforms')
                return
            zLOG.LOG('AutoLance', zLOG.INFO, 'MemChecker limit set to '
                     '%s kbytes,checking every %s secs'%(self.size,self.every))
            import linuxproc, time, sys, resource
            pagesize = resource.getpagesize()/1024
            while 1:
                time.sleep(self.every)
                try:
                    statm = linuxproc.self_statm()
                    psize = statm.get('resident') * pagesize
                    if psize > self.size:
                        import ZServer
                        def shutdatabases():
                            import Globals
                            for db in Globals.opened:
                                db.close()
                        import socket, os
                        id = os.environ.get(
                            'ZEO_CLIENT',
                            socket.gethostbyaddr(socket.gethostname())[0])
                        args = (id, psize, self.size)
                        msg = (
                            "Restarting %s after process size limit exceeded."
                            "(size %s exceeds limit %s)" % args
                            )
                        ZServer.clean_shutdown(
                            restart=1,
                            callback=shutdatabases,
                            msg=msg,
                            subj='Zope restarting',
                            mailto=self.mailto,
                            mailfrom=self.mailfrom,
                            smtpserver=self.smtpserver,
                            sleep=self.sleep
                            )
                        break
                except SystemExit:
                    break
                except:
                    zLOG.LOG('AutoLance', zLOG.PROBLEM,
                             'AutoLance memchecker died', '', sys.exc_info())
                    break

    t = AutoLanceMemChecker(size=ZOPE_MEMLIMIT,
                            every=ZOPE_MEMLIMIT_CHECK_EVERY,
                            mailto=EMAIL_TO,
                            mailfrom=EMAIL_FROM,
                            smtpserver=SMTP_SERVER,
                            sleep=SLEEP_BEFORE_RESTART
                            )
    t.start()
    

    
