# Copyright (C) 2001 Stfane Fermigier <sf@fermigier.com> and
# Nuxeo SARL <contact@nuxeo.com>.
# See licence info at the end of this file or in this directory.

import HTMLDocument
from ZClasses import createZClassForBase
 
createZClassForBase(HTMLDocument.HTMLDocument, globals(), 
  'ZHTMLDocument', 'HTML Document')

def initialize(context):
	"Initialize the HTML Document product"
	context.registerClass(
		HTMLDocument.HTMLDocument,
		permission='Add HTML Documents',
		constructors=(
			HTMLDocument.addHTMLDocumentForm,
			HTMLDocument.addHTMLDocument,
		),
		icon="www/icon.gif"
	)


def PUT_factory( self, name, typ, body ):
	from OFS.Image import Image, File
	from OFS.DTMLDocument import DTMLDocument

	if typ == 'text/html':
		ob = HTMLDocument.HTMLDocument('', __name__=name)
	elif typ in ('text/xml', 'text/plain'):
		ob = DTMLDocument('', __name__=name)
	elif typ[:6] == 'image/':
		ob = Image(name, '', body, content_type=typ)
	else:
		ob = File(name, '', body, content_type=typ)
	return ob

import webdav.NullResource
webdav.NullResource.NullResource._default_PUT_factory = PUT_factory

