#!/usr/local/bin/python

import sys, os
sys.path.append(os.environ.get('ZOPE_HOME', '../../..') + '/lib/python')
import time, unittest, re, string, profile

import Zope
from Testing import makerequest

app = makerequest.makerequest(Zope.app())

# 
# Setup testing folder
#
app.manage_addFolder(id='unit_testing')
app.unit_testing.manage_addDTMLMethod(id='standard_html_header',
  file='<html><head><title><dtml-var title></title></head><body>')
app.unit_testing.manage_addDTMLMethod(id='standard_html_footer',
  file='</body></html>')

#
# Setup a ZCatalog to test CatalogAwareness
#
app.unit_testing.manage_addProduct['ZCatalog']\
  .manage_addZCatalog('Catalog', title='')
catalog = app.unit_testing.Catalog

#
# Add test HTML document

def addDocument(app, fn):
  app.unit_testing.manage_addProduct['HTMLDocument']\
      .addHTMLDocument('doc', file=open(fn).read())

print 'Adding document...'
t0 = time.time()
profile.run('addDocument(app, "whitehouse.html")')
print 'Adding document done (t=%f)' % (time.time()-t0)

# vim:ts=2:et
