#!/usr/bin/python

import sys, os
sys.path.append(os.environ.get('ZOPE_HOME', '../../..') + '/lib/python')
import time, unittest, re, string

import Zope
from Testing import makerequest

class HTMLDocumentBaseTestCase(unittest.TestCase):
  def setUp(self):
    self.app = makerequest.makerequest(Zope.app())

    # 
    # Setup testing folder
    #
    self.app.manage_addFolder(id='unit_testing')
    self.app.unit_testing.manage_addDTMLMethod(id='standard_html_header',
      file='<html><head><title><dtml-var title></title></head><body>')
    self.app.unit_testing.manage_addDTMLMethod(id='standard_html_footer',
      file='</body></html>')

    #
    # Setup a ZCatalog to test CatalogAwareness
    #
    self.app.unit_testing.manage_addProduct['ZCatalog']\
      .manage_addZCatalog('Catalog', title='')
    self.catalog = self.app.unit_testing.Catalog

    #
    # Add test HTML document
    #
    self.app.unit_testing.manage_addProduct['HTMLDocument']\
      .addHTMLDocument('doc', file=open('test1.html').read())

    # We must use acquisition here
    self.doc = self.app.unit_testing.doc

  def tearDown(self):
    get_transaction().abort()
    self.app._p_jar.close()


class HTMLDocumentTestCase1(HTMLDocumentBaseTestCase):
  def testUpload(self):
    s = '<html><body>toto</body></html>'
    self.doc.manage_upload(s)
    self.assertEqual(self.doc.PrincipiaSearchSource(), 'toto')
    self.assertEqual(self.doc.html_src, s)
    self.assertEqual(self.doc.manage_FTPget(), s)
    self.assertEqual(self.doc.document_src(), s)
    self.assert_(string.count(self.doc(), 'toto') == 1)


class HTMLDocumentTestCase2(HTMLDocumentBaseTestCase):
  def testEdit(self):
    s = '<html><body>titi</body></html>'
    self.doc.manage_edit(data=s, title='XXXtitle')
    self.assertEqual(self.doc.PrincipiaSearchSource(), 'titi')
    self.assertEqual(self.doc.title, 'XXXtitle')
    self.assertEqual(self.doc.html_src, s)
    self.assertEqual(self.doc.manage_FTPget(), s)
    self.assertEqual(self.doc.document_src(), s)
    self.assert_(string.count(self.doc(), 'XXXtitle') == 1)

  # PUT needs proper REQUEST and RESPONSE
  def testFTP(self):
    s = '<html><body>tata</body></html>'
    REQUEST = self.app.REQUEST
    REQUEST['BODY'] = s
    self.doc.PUT(REQUEST, REQUEST.RESPONSE)
    get_res = self.doc.manage_FTPget()
    self.assertEqual(get_res, s)

class HTMLDocumentTestCase3(HTMLDocumentBaseTestCase):
  def testCatalog(self):
    #
    # First, use stock content (includes the word 'Linux')
    #
    brain_list = self.catalog(PrincipiaSearchSource='XXXYYYztuv')
    self.assert_(len(brain_list) == 0)

    brain_list = self.catalog(PrincipiaSearchSource='linux')
    self.assertEqual(len(brain_list), 1)
    self.assertEqual(brain_list[0].getURL(), 'http://foo/unit_testing/doc')
    doc = brain_list[0].getObject()
    self.assertEqual(doc.aq_base, self.doc.aq_base)

    words = map(lambda x: x[0], self.catalog.vocabulary.words())
    self.assert_('linux' in words)

    #
    # Now update object.
    #
    s = '<html><body>titititi tt tutu</body></html>'
    self.doc.manage_edit(data=s, title='XXXtitle')

    brain_list = self.catalog(PrincipiaSearchSource='titi')
    self.assertEqual(len(brain_list), 0)

    brain_list = self.catalog(PrincipiaSearchSource='tutu')
    self.assertEqual(len(brain_list), 1)

    brain_list = self.catalog(PrincipiaSearchSource='tt')
    self.assertEqual(len(brain_list), 1)

if __name__ == '__main__':
  unittest.main()

# vim:ts=2:et
