#!/usr/bin/python

import sys
sys.path.insert(0, '..')
import parser, unittest, time

class ParserTestCase(unittest.TestCase):

  def setUp(self):
    self.p = parser.HTMLParser()

  def test1(self):
    self.p.feed(document1)
    self.p.close()

    self.assertEquals(self.p.getTitle(), 'This is the title')
    self.assertEquals(self.p.getAuthor(), 'au.thor')
    self.assertEquals(self.p.getDescription(), 'This is the description.')
    self.assertEquals(self.p.getKeywords(), 'key1, key2, key3')
    self.assertEquals(self.p.getSource(), 'source')
    self.assertEquals(self.p.getPublisher(), 'publisher')
    self.assertEquals(self.p.getRaw(), 'This is the body.')


document1 = \
'''<html>
<head>
<title>This is the title</title>
<meta name='author' content="au.thor">
<meta name="description" content="This is the description.">
<meta name="keywords" content="key1, key2, key3">
<meta name="dc.source" content="source">
<meta name="dc.publisher" content="publisher">
</head>
<body>
This is the body.
</body>
</html>
'''

if __name__ == '__main__':
  unittest.main()


