#
# Copyright 2001 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
ADD_CONTENT_PERMISSION = 'Add portal content'



from Globals import InitializeClass
from AccessControl import ClassSecurityInfo, getSecurityManager

from Products.CMFCore.PortalContent import PortalContent
from Products.CMFDefault.DublinCore import DefaultDublinCoreImpl
from Products.CMFCore import CMFCorePermissions, utils
#from Products.CMFCore.WorkflowCore import WorkflowAction, afterCreate
from Products.CMFCore.utils import _format_stx, keywordsplitter
from Products.CMFDefault.utils \
     import parseHeadersBody, SimpleHTMLParser, bodyfinder, _dtmldir


from NuxDocument import NuxDocument

factory_type_information = ({
  'id': 'NuxDocument',
  'meta_type': 'CMFNuxDocument',
  'description': """Generic documents.""",
  'icon': 'document_icon.gif',
  'product': 'NuxDocument',
  'factory': 'addCMFNuxDocument',
  'immediate_view': 'metadata_edit_form',
  'actions': (
    {
      'name': 'Download',
      'action': '',
      'permissions': (CMFCorePermissions.View,)
    }, 
    {
      'name': 'View',
      'action': 'NuxDocument_view',
      'permissions': (CMFCorePermissions.View,)
    }, 
    { 
      'name': 'Edit',
      'action': 'NuxDocument_edit_form',
      'permissions': (CMFCorePermissions.ModifyPortalContent,)
    },
    {
      'name': 'Metadata',
      'action': 'metadata_edit_form',
      'permissions': (CMFCorePermissions.ModifyPortalContent,)
    })
},)


def addCMFNuxDocument(self, id, title='', file=''):
    """ Add a NuxDocument """
    o = CMFNuxDocument(id, title=title, file=file)
    self._setObject(id, o)


class CMFNuxDocument(PortalContent, NuxDocument, DefaultDublinCoreImpl):
    "A Document - Handles whatever type is understood by the plugins"

    meta_type = 'CMFNuxDocument'
    effective_date = expiration_date = None
    _isDiscussable = 1

    security = ClassSecurityInfo()

    def __init__(self, id, title='', file=''):
        DefaultDublinCoreImpl.__init__(self)
        NuxDocument.__init__(self, id=id, file=file)

    def _edit(self, title=None, file=None, mime_type=None):
        NuxDocument._edit(self, title, file, mime_type)
        if hasattr(self, 'setModificationDate'):
            self.setModificationDate()
        if hasattr(self, 'portal_catalog'): # do we have a context ? XXX
            self.reindexObject() # from PortalContent

    security.declareProtected(CMFCorePermissions.ModifyPortalContent, 'edit')
    def edit(self, title, file, mime_type=''):
        NuxDocument._edit(self, title, file, mime_type)
        if hasattr(self, 'setModificationDate'):
            self.setModificationDate()
        self.reindexObject() # from PortalContent

    security.declareProtected('View', 'index_html')
    def index_html(self, RESPONSE=None):
        'Default view'
        # XXX: check if and how filename needs to be escaped
        RESPONSE.setHeader('Content-Disposition', "inline; filename=%s"
          % self.filename)
        return self.document_src(RESPONSE=RESPONSE)

    security.declareProtected('View', 'CookedBody')
    def CookedBody(self):
      return bodyfinder(self._html)

    security.declareProtected('View', 'SearchableText')
    def SearchableText(self):
        return NuxDocument.SearchableText(self)

#    def manage_afterAdd(self, item, container):
#        return PortalContent.manage_afterAdd(self, item, container)


#    security.declareProtected(CMFCorePermissions.ModifyPortalContent,
#                              'manage_edit')
#    manage_edit = DTMLFile('zmi_editDocument', _dtmldir)
#
#    security.declareProtected(CMFCorePermissions.ModifyPortalContent,
#                              'manage_editDocument' )
#    def manage_editDocument(self, text_format, text, file='', REQUEST=None):
#        """ A ZMI (Zope Management Interface) level editing method """
#        self._edit(text_format, text, file)
#        if REQUEST is not None:
#            REQUEST['RESPONSE'].redirect(
#                self.absolute_url()
#                + '/manage_edit'
#                + '?manage_tabs_message=Document+updated'
#                )
#
#    def _edit(self, text_format, text, file='', safety_belt=''):
#        """ Edit the Document - Parses headers and cooks the body"""
#        self.text = text
#        headers = {}
#        if file and (type(file) is not type('')):
#            contents=file.read()
#            if contents:
#                text = self.text = contents
#
#        headers, body, cooked, format = self.handleText(text, text_format)
#
#        if not safety_belt:
#            safety_belt = headers.get('SafetyBelt', '')
#        if not self._safety_belt_update(safety_belt=safety_belt):
#            msg = ("Intervening changes from elsewhere detected."
#                   " Please refetch the document and reapply your changes."
#                   " (You may be able to recover your version using the"
#                   " browser 'back' button, but will have to apply them"
#                   " to a freshly fetched copy.)")
#            raise 'EditingConflict', msg
#
#        self.text_format = format
#        self.cooked_text = cooked
#        self.text = body
#
#        headers['Format'] = self.Format()
#        new_subject = keywordsplitter(headers)
#        headers['Subject'] = new_subject or self.Subject()
#        haveheader = headers.has_key
#        for key, value in self.getMetadataHeaders():
#            if key != 'Format' and not haveheader(key):
#                headers[key] = value
#        
#        self.editMetadata(title=headers['Title'],
#                          subject=headers['Subject'],
#                          description=headers['Description'],
#                          contributors=headers['Contributors'],
#                          effective_date=headers['Effective_date'],
#                          expiration_date=headers['Expiration_date'],
#                          format=headers['Format'],
#                          language=headers['Language'],
#                          rights=headers['Rights'],
#                          )
#
#    security.declareProtected( CMFCorePermissions.ModifyPortalContent, 'edit' )
#    edit = WorkflowAction(_edit)
#
#    security.declarePrivate('guessFormat')
#    def guessFormat(self, text):
#        """ Simple stab at guessing the inner format of the text """
#        if bodyfinder.search(text) is not None:
#            return 'html'
#        else:
#            return 'structured-text'
#    
#    security.declarePrivate('handleText')
#    def handleText(self, text, format=None, stx_level=None):
#        """ Handles the raw text, returning headers, body, cooked, format """
#        headers = {}
#        body = cooked = text
#        level = stx_level or self._stx_level
#
#        if not format:
#            format = self.guessFormat(text)
#
#        if format == 'html':
#            parser = SimpleHTMLParser()
#            parser.feed(text)
#            headers.update(parser.metatags)
#            if parser.title:
#                headers['Title'] = parser.title
#            bodyfound = bodyfinder.search(text)
#            if bodyfound:
#                cooked = body = bodyfound.group('bodycontent')
#        else:
#            headers, body = parseHeadersBody(text, headers)
#            cooked = _format_stx(text=body, level=level)
#            self._stx_level = level
#
#        return headers, body, cooked, format
#            
#    security.declarePublic( 'getMetadataHeaders' )
#    def getMetadataHeaders(self):
#        """Return RFC-822-style header spec."""
#        hdrlist = DefaultDublinCoreImpl.getMetadataHeaders(self)
#        hdrlist.append( ('SafetyBelt', self._safety_belt) )
#        return hdrlist
#
#    security.declarePublic( 'SafetyBelt' )
#    def SafetyBelt(self):
#        """Return the current safety belt setting.
#        For web form hidden button."""
#        return self._safety_belt
#
#    def _safety_belt_update(self, safety_belt=''):
#        """Check validity of safety belt and update tracking if valid.
#
#        Return 0 if safety belt is invalid, 1 otherwise.
#
#        Note that the policy is deliberately lax if no safety belt value is
#        present - "you're on your own if you don't use your safety belt".
#
#        When present, either the safety belt token:
#         - ... is the same as the current one given out, or
#         - ... is the same as the last one given out, and the person doing the
#           edit is the same as the last editor."""
#
#        this_belt = safety_belt
#        this_user = getSecurityManager().getUser().getUserName()
#
#        if (# we have a safety belt value:
#            this_belt
#            # and the current object has a safety belt (ie - not freshly made)
#            and (self._safety_belt is not None)
#            # and the safety belt doesn't match the current one:
#            and (this_belt != self._safety_belt)
#            # and safety belt and user don't match last safety belt and user:
#            and not ((this_belt == self._last_safety_belt)
#                     and (this_user == self._last_safety_belt_editor))):
#            # Fail.
#            return 0
#
#        # We qualified - either:
#        #  - the edit was submitted with safety belt stripped, or
#        #  - the current safety belt was used, or
#        #  - the last one was reused by the last person who did the last edit.
#        # In any case, update the tracking.
#
#        self._last_safety_belt_editor = this_user
#        self._last_safety_belt = this_belt
#        self._safety_belt = str(self._p_mtime)
#
#        return 1
#
#    ### Content accessor methods
#    security.declareProtected(CMFCorePermissions.View, 'SearchableText')
#    def SearchableText(self):
#        """ Used by the catalog for basic full text indexing """
#        return "%s %s %s" % (self.title, self.description, self.text)
#
#    security.declareProtected(CMFCorePermissions.View, 'CookedBody')
#    def CookedBody(self, stx_level=None, setlevel=0):
#        """\
#        The prepared basic rendering of an object.  For Documents, this
#        means pre-rendered structured text, or what was between the
#        <BODY> tags of HTML.
#
#        If the format is html, and 'stx_level' is not passed in or is the
#        same as the object's current settings, return the cached cooked
#        text.  Otherwise, recook.  If we recook and 'setlevel' is true,
#        then set the recooked text and stx_level on the object.
#        """
#        if (self.text_format == 'html'
#            or (stx_level is None)
#            or (stx_level == self._stx_level)):
#            return self.cooked_text
#        else:
#            cooked = _format_stx(self.text, stx_level)
#            if setlevel:
#                self._stx_level = stx_level
#                self.cooked_text = cooked
#            return cooked
#
#    security.declareProtected(CMFCorePermissions.View, 'EditableBody')
#    def EditableBody(self):
#        """\
#        The editable body of text.  This is the raw structured text, or
#        in the case of HTML, what was between the <BODY> tags.
#        """
#        return self.text
#
#    security.declareProtected(CMFCorePermissions.View, 'Description')
#    def Description(self):
#        """ Dublin core description, also important for indexing """
#        return self.description
#    
#    security.declareProtected(CMFCorePermissions.View, 'Format')
#    def Format(self):
#        """ Returns a content-type style format of the underlying source """
#        if self.text_format == 'html':
#            return 'text/html'
#        else:
#            return 'text/plain'
#    
#
#    security.declareProtected(CMFCorePermissions.ModifyPortalContent,
#                             'setFormat' )
#    def setFormat(self, value):
#        value = str(value)
#        if value == 'text/html':
#            self.text_format = 'html'
#        else:
#            self.text_format = 'structured-text'
#    setFormat = WorkflowAction(setFormat)
#
#    ## FTP handlers
#    security.declareProtected(CMFCorePermissions.ModifyPortalContent, 'PUT')
#    def PUT(self, REQUEST, RESPONSE):
#        """ Handle HTTP (and presumably FTP?) PUT requests """
#        self.dav__init(REQUEST, RESPONSE)
#        body = REQUEST.get('BODY', '')
#        guessedformat = REQUEST.get_header('Content-Type', 'text/plain')
#        ishtml = (guessedformat == 'text/html') or utils.html_headcheck(body)
#
#        if ishtml: self.setFormat('text/html')
#        else: self.setFormat('text/plain')
#
#        try:
#            self.edit(text_format=self.text_format, text=body)
#        except 'EditingConflict', msg:
#            # XXX Can we get an error msg through?  Should we be raising an
#            #     exception, to be handled in the FTP mechanism?  Inquiring
#            #     minds...
#            get_transaction().abort()
#            RESPONSE.setStatus(450)
#            return RESPONSE
#
#        RESPONSE.setStatus(204)
#        return RESPONSE
#
#    _htmlsrc = (
#        '<html>\n <head>\n'
#        ' <title>%(title)s</title>\n'
#        '%(metatags)s\n'
#        ' </head>\n'
#        ' <body>\n%(body)s\n </body>\n'
#        '</html>\n'
#        )
#
#    security.declareProtected( CMFCorePermissions.View, 'manage_FTPget' )
#    def manage_FTPget(self):
#        "Get the document body for FTP download (also used for the WebDAV SRC)"
#        join = string.join
#        lower = string.lower
#        hdrlist = self.getMetadataHeaders()
#        if self.Format() == 'text/html':
#            hdrtext = ''
#            for name, content in hdrlist:
#                if lower(name) == 'title':
#                    continue
#                else:
#                    hdrtext = '%s\n <meta name="%s" content="%s" />' % (
#                        hdrtext, name, content)
#
#            bodytext = self._htmlsrc % {
#                'title': self.Title(),
#                'metatags': hdrtext,
#                'body': self.text,
#                }
#        else:
#            hdrtext = join(map(lambda x: '%s: %s' % (
#                x[0], x[1]), hdrlist), '\n')
#            bodytext = '%s\n\n%s' % ( hdrtext, self.text )
#
#        return bodytext
#
#    security.declareProtected( CMFCorePermissions.View, 'get_size' )
#    def get_size( self ):
#        """ Used for FTP and apparently the ZMI now too """
#        return len(self.manage_FTPget())

InitializeClass(NuxDocument)
