#
# Copyright 2001 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#

"""NuxDocuments

"""

__version__='$Revision: 1.10 $'[11:-2]

from urllib import quote
import re, string

from OFS.SimpleItem import SimpleItem, Item_w__name__
from OFS.PropertyManager import PropertyManager
from OFS.Cache import Cacheable
from OFS.History import Historical
from Products.ZCatalog.CatalogAwareness import CatalogAware
from DateTime.DateTime import DateTime
from AccessControl import ClassSecurityInfo
from Globals import InitializeClass

from Products.Localizer import LocalDTMLFile

from NuxDocument import NuxDocument
import plugins


class ZNuxDocument(CatalogAware, NuxDocument, SimpleItem,
                   PropertyManager, Historical, Cacheable, Item_w__name__):
  # + ElementWithTitle (XXX ???)

  """NuxDocuments"""

  meta_type = 'NuxDocument'
##  icon = 'p_/dtmldoc'

  index_html = None # Prevent accidental acquisition (XXX ???)

  manage_options = (
    (
      {'label':'Edit', 'action':'manage_main'},
      {'label':'View', 'action':''},
      {'label':'Tidy', 'action':'manage_tidy'},
    )
    + PropertyManager.manage_options
    + Cacheable.manage_options
    + Historical.manage_options
  )

  security = ClassSecurityInfo()

  #_metadata = ['title', 'author', 'publisher', 'source',
  #  'publication_date', 'description', 'keywords', 'summary']
  #title = author = publisher = source = description = keywords = summary = ''
  #_properties = (
  #  {'id':'title', 'type': 'string', 'mode': 'w'},
  #  {'id':'author', 'type': 'string', 'mode': 'w'},
  #  {'id':'publisher', 'type': 'string', 'mode': 'w'},
  #  {'id':'source', 'type': 'string', 'mode': 'w'},
  #  {'id':'publication_date', 'type': 'date', 'mode': 'w'},
  #  {'id':'description', 'type': 'text', 'mode': 'w'},
  #  {'id':'keywords', 'type': 'text', 'mode': 'w'},
  #)

  security.declareProtected('View', '__call__')
  def __call__(self, client=None, REQUEST={}, RESPONSE=None, **kw):
    "View document"

    res = self.standard_html_header(self, REQUEST) 
    res = res + self._html 
    res = res + self.standard_html_footer(self, REQUEST)
    return res

  #
  # Updating content
  #
  security.declareProtected('Add NuxDocument', 'manage_editForm')
  manage_editForm = LocalDTMLFile('zmi/editForm', globals())

  security.declareProtected('Edit NuxDocument', 'manage')
  manage = manage_main = manage_editForm

  def _edit(self, title, file, mime_type=None):
    NuxDocument._edit(self, title, file, mime_type)
    self.reindex_object() # from CatalogAware
    self.ZCacheable_invalidate()

  security.declareProtected('Edit NuxDocument', 'manage_edit')
  def manage_edit(self, data=None, title=None, SUBMIT='Change', REQUEST=None):
    """
    Replaces a Documents contents with Data.

    The SUBMIT parameter is also used to change the size of the editing
    area on the default Document edit screen.  If the value is "Smaller",
    the rows and columns decrease by 5.  If the value is "Bigger", the
    rows and columns increase by 5.  If any other or no value is supplied,
    the data gets checked for DTML errors and is saved.
    """

    #if self._size_changes.has_key(SUBMIT):
    #  return self._er(data, SUBMIT, dtpref_cols, dtpref_rows, REQUEST)

    if data and type(data) is not type(''): 
      data = data.read()
    self._edit(title, data)

    if REQUEST:
      message="Content changed."
      return self.manage_main(self,REQUEST,manage_tabs_message=message)


  security.declareProtected('Edit NuxDocument', 'manage_upload')
  def manage_upload(self, file='', REQUEST=None):
    """Replace the contents of the document with the text in file."""

    #mime_type = 'XXX'
    title = self.title
    if type(file) is not type(''): 
      file = file.read()
    self._edit(title, file)

    if REQUEST:
      message="Content uploaded."
      return self.manage_main(self,REQUEST,manage_tabs_message=message)

  security.declareProtected('Edit NuxDocument', 'PUT')
  def PUT(self, REQUEST, RESPONSE):
    "Handle HTTP/FTP PUT requests."

    self.dav__init(REQUEST, RESPONSE)
    data = REQUEST.get('BODY', '')
    #mime_type = 'XXX'
    title = self.title
    if type(data) is not type(''): 
      data = data.read()
    self._edit(title, data)

    RESPONSE.setStatus(204)
    return RESPONSE


InitializeClass(NuxDocument)

addZNuxDocumentForm = LocalDTMLFile('zmi/addForm', globals())

def cookId(id, file):
  if not id and hasattr(file, 'filename'):
    filename = file.filename
    id = filename[max(
      string.rfind(filename, '/'),
      string.rfind(filename, '\\'),
      string.rfind(filename, ':'),)+1:]
  return id

def addZNuxDocument(self, id, title='', file='', REQUEST=None, submit=None):
  """Add a ZNuxDocument object with the contents of <file>."""

  id = str(id)
  id = cookId(id, file)
  if type(file) is not type(''): 
    file = file.read()

  ob = ZNuxDocument(id=id, title=title, file=file)
  id = self._setObject(id, ob)
  if REQUEST is not None:
    try: u = self.DestinationURL()
    except: u = REQUEST['URL1']
    if submit == " Add and Edit ": u = "%s/%s" % (u, quote(id))
    REQUEST.RESPONSE.redirect(u + '/manage_main')
  return ''

# vim:et:ts=2:ai
