#
# Copyright 2001 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#

import sys
import ZNuxDocument, CMFNuxDocument
from ZClasses import createZClassForBase

try:
  from Products.CMFCore import utils, CMFCorePermissions
  from Products.CMFCore.DirectoryView import registerDirectory
  _has_cmf = 1
except:
  _has_cmf = 0

 
#createZClassForBase(NuxDocument.NuxDocument, globals(), 
#  'ZNuxDocument', 'NuxDocument')

this_module = sys.modules[__name__]

if _has_cmf:
  contentClasses = (CMFNuxDocument.CMFNuxDocument,)
  contentConstructors = (CMFNuxDocument.addCMFNuxDocument,)
  z_bases = utils.initializeBasesPhase1(contentClasses, this_module)

  # Make the skins available as DirectoryViews
  registerDirectory('skins', globals())
  registerDirectory('skins/NuxDocument', globals())

def initialize(context):
  "Initialize the NuxDocument product"
  context.registerClass(
    ZNuxDocument.ZNuxDocument,
    permission='Add ZNuxDocuments',
    constructors=(
      ZNuxDocument.addZNuxDocumentForm,
      ZNuxDocument.addZNuxDocument,
    ),
    # icon="www/icon.gif"
  )

  if _has_cmf:
    utils.initializeBasesPhase2(z_bases, context)

    utils.ContentInit("CMF NuxDocument",
      content_types = contentClasses,
      permission = CMFCorePermissions.AddPortalContent,
      extra_constructors = contentConstructors,
      fti = CMFNuxDocument.factory_type_information
    ).initialize(context)


#def PUT_factory( self, name, typ, body ):
#  from OFS.Image import Image, File
#  from OFS.DTMLDocument import DTMLDocument
#
#  if typ == 'text/html':
#    ob = NuxDocument.NuxDocument('', __name__=name)
#  elif typ in ('text/xml', 'text/plain'):
#    ob = DTMLDocument('', __name__=name)
#  elif typ[:6] == 'image/':
#    ob = Image(name, '', body, content_type=typ)
#  else:
#    ob = File(name, '', body, content_type=typ)
#  return ob
#
#import webdav.NullResource
#webdav.NullResource.NullResource._default_PUT_factory = PUT_factory

