#
# Copyright 2001-2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
from plugin import Plugin, ExternalConverterBase, ConversionError
import os, re, misc

# wv config file (wvZope.xml) is in same directory as this module.
XSL_STYLESHEET = os.path.join(
  os.getcwd(), os.path.dirname(__file__), 'oo2html.xsl')

def debug(s):
  #print s
  pass

class OpenOfficeConverter(ExternalConverterBase):
  suffix = 'zip'

  # XXX: mime type should be different for writer/presenter/spread...
  mime_type = 'application/unknown' 

  def _convertToHtml(self):
    cmd = "cd '%s' && unzip '%s' " % (self.tmpdir, self.name)
    debug(cmd)
    misc.systemWithTimeout(cmd, 30)

    try:
      content = open('%s/content.xml' % self.tmpdir).read()
    except:
      debug('content.xml not found')
      raise ConversionError
    if not re.search('DOCTYPE office:document-content PUBLIC', content):
      debug('Bad DOCTYPE')
      raise ConversionError

    cmd = "cd '%s' && xsltproc --novalid %s content.xml > %s.html " \
      "2> %s.log-xsltproc" % (
        self.tmpdir, XSL_STYLESHEET, self.name, self.name)
    debug(cmd)
    misc.systemWithTimeout(cmd, 30)
    # XXX: we should probably test something here

    # XXX: todo: add support for metadata.xml.


p = Plugin('OpenOffice', [OpenOfficeConverter])
p.addAcceptableMimeType('application/zip')
p.addAcceptableMimeType('application/vnd.sun.xml.writer')
p.addAcceptableMimeType('application/vnd.sun.xml.impress')
p.addAcceptableMimeType('application/vnd.sun.xml.calc')
p.addAcceptableFileType('Zip archive data, at least v2.0 to extract')
 
def getPlugin():
  return p                                                                      

