#
# Copyright 2001, 2002 Stfane Fermigier and Nuxeo SARL
# See LICENSE.TXT for licensing information
#
from plugin import ConverterBase, Plugin

import os, tempfile, re, cgi

class Converter(ConverterBase):
  def __init__(self, name, data):
    ConverterBase.__init__(self, name, data)

    self.tmpdir = tempfile.mktemp()
    os.mkdir('%s' % self.tmpdir)

    fd = open("%s/%s.pdf" % (self.tmpdir, self.name), "w")
    fd.write(self.data)
    fd.close()

    self._convert()

  def __del__(self):
    for fn in os.listdir("%s" % self.tmpdir):
      os.remove("%s/%s" % (self.tmpdir, fn))
    os.rmdir("%s" % self.tmpdir)

  def _convert(self):
    cmd = "cd '%s' && pdftotext '%s.pdf' 2> /dev/null" \
      % (self.tmpdir, self.name)
    os.system(cmd)

  #
  # Accessors to get results.
  #
  def getMimeType(self):
    return 'application/pdf'

  def getText(self):
    text = open("%s/%s.txt" % (self.tmpdir, self.name)).read()
    return text

  def getHtml(self):
    return '<pre>' + cgi.escape(self.getText()) + '</pre>'

  def getImageNames(self):
    return []

p = Plugin('PDF', [Converter])
p.addAcceptableMimeType('text/pdf')
p.addAcceptableMimeType('application/pdf')
p.addAcceptableFileType('PDF document.*')

def getPlugin():
  return p

# vim:ts=2
